/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.expr.LocationPath;
import org.planx.xpath.object.XNodeSet;
import org.planx.xpath.object.XObject;

public class PathExpression
extends Expression {
    private final Expression expr;
    private final LocationPath locationPath;

    public PathExpression(Expression expr, LocationPath locationPath) {
        this.expr = expr;
        this.locationPath = locationPath;
    }

    @Override
    public XObject evaluate(Context ctxt, Environment env, Navigator nav) throws XPathException {
        try {
            XNodeSet set = (XNodeSet)this.expr.evaluate(ctxt, env, nav);
            return this.locationPath.evaluate(set, env, nav);
        }
        catch (ClassCastException e) {
            throw new XPathException("Expression did not evaluate to an XNodeSet: " + this.expr);
        }
    }

    public String toString() {
        return this.expr.toString() + "/" + this.locationPath.toString();
    }
}

