/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.NodeTest;

public class NodeTypeTest
extends NodeTest {
    public static final int PRINCIPAL = 1;
    public static final int TEXT = 2;
    public static final int NODE = 3;
    private int nodeType;

    public NodeTypeTest(int nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public boolean matches(Object node, int principalNodeType, Navigator navigator) throws XPathException {
        int type = navigator.getType(node);
        switch (this.nodeType) {
            case 1: {
                return type == principalNodeType;
            }
            case 2: {
                return type == 3;
            }
            case 3: {
                return true;
            }
        }
        throw new RuntimeException("Unsupported type: " + this.nodeType);
    }

    public String toString() {
        switch (this.nodeType) {
            case 1: {
                return "*";
            }
            case 2: {
                return "text()";
            }
            case 3: {
                return "node()";
            }
        }
        return "ILLEGAL";
    }
}

