/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.expr.NodeTest;
import org.planx.xpath.expr.PredicateList;
import org.planx.xpath.expr.Step;
import org.planx.xpath.expr.axis.Axis;
import org.planx.xpath.expr.axis.AxisIterator;
import org.planx.xpath.object.XNodeSet;
import org.planx.xpath.object.XObject;

public class LocationPath
extends Expression {
    protected List steps = new ArrayList();
    protected boolean isAbsolute;

    public void appendStep(Step step) {
        this.steps.add(step);
    }

    public void prependStep(Step step) {
        this.steps.add(0, step);
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public void setAbsolute(boolean isAbsolute) {
        this.isAbsolute = isAbsolute;
    }

    @Override
    public XObject evaluate(Context ctxt, Environment env, Navigator nav) throws XPathException {
        XNodeSet atomSet = new XNodeSet(1);
        atomSet.add(ctxt.getNode());
        return this.evaluate(atomSet, env, nav);
    }

    public XObject evaluate(XNodeSet nodes, Environment env, Navigator nav) throws XPathException {
        if (this.isAbsolute) {
            Object root = nav.getRoot(nodes.get(0));
            nodes = new XNodeSet(1);
            nodes.add(root);
        }
        Axis axis = null;
        int numOfSteps = this.steps.size();
        for (int i = 0; i < numOfSteps; ++i) {
            Step step = (Step)this.steps.get(i);
            axis = step.getAxis();
            NodeTest nodeTest = step.getNodeTest();
            PredicateList predicates = step.getPredicates();
            XNodeSet axisNodes = new XNodeSet();
            HashSet<Object> unique = new HashSet<Object>();
            int size = nodes.size();
            for (int j = 0; j < size; ++j) {
                Object ctxtNode = nodes.get(j);
                int principalNodeType = axis.getPrincipalNodeType();
                AxisIterator axisIt = axis.iterator(ctxtNode, nav);
                while (axisIt.hasNext()) {
                    Object node = axisIt.next();
                    if (!nodeTest.matches(node, principalNodeType, nav) || unique.contains(node)) continue;
                    axisNodes.add(node);
                    unique.add(node);
                }
            }
            nodes = predicates.evaluate(axisNodes, env, nav);
            if (!axis.isReverse()) continue;
            int size2 = nodes.size();
            XNodeSet reverse = new XNodeSet(size2);
            for (int j = 0; j < size2; ++j) {
                reverse.add(nodes.get(size2 - j - 1));
            }
            nodes = reverse;
        }
        return nodes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.steps.size(); ++i) {
            if (i > 0 || this.isAbsolute) {
                sb.append("/");
            }
            sb.append(this.steps.get(i).toString());
        }
        return sb.toString();
    }
}

