/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.stores;

import java.io.IOException;
import java.util.Map;
import org.planx.util.LRUCache;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.XMLStore;
import org.planx.xmlstore.stores.AbstractXMLStore;

public class WriteCacheXMLStore
extends AbstractXMLStore {
    private Map<Reference, Node> cache = new LRUCache<Reference, Node>();

    public WriteCacheXMLStore(XMLStore xmlstore) {
        super(xmlstore);
    }

    @Override
    public Reference save(Node n) throws IOException {
        this.checkClosed();
        Reference ref = this.xmlstore.save(n);
        this.cache.put(ref, n);
        return ref;
    }

    @Override
    public Node load(Reference vref) throws IOException, UnknownReferenceException {
        this.checkClosed();
        Node n = this.cache.get(vref);
        if (n == null) {
            n = this.xmlstore.load(vref);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.cache = null;
    }
}

