/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.stores;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.XMLStore;
import org.planx.xmlstore.nodes.BlockingNodeProxy;
import org.planx.xmlstore.nodes.SystemNode;
import org.planx.xmlstore.stores.AbstractXMLStore;
import org.planx.xmlstore.util.Concurrency;

public class OptimisticReadXMLStore
extends AbstractXMLStore {
    public OptimisticReadXMLStore(XMLStore xmlstore) {
        super(xmlstore);
    }

    @Override
    public Node load(final Reference vref) throws IOException, UnknownReferenceException {
        this.checkClosed();
        Callable<SystemNode> callable = new Callable<SystemNode>(){

            @Override
            public SystemNode call() throws IOException, UnknownReferenceException {
                return (SystemNode)OptimisticReadXMLStore.this.xmlstore.load(vref);
            }
        };
        Future<SystemNode> future = Concurrency.localExecutor().submit(callable);
        return new BlockingNodeProxy(vref, future);
    }
}

