/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.messaging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.planx.xmlstore.routing.messaging.Message;
import org.planx.xmlstore.routing.messaging.MessageFactory;
import org.planx.xmlstore.routing.messaging.Receiver;

public class MessageServer {
    private static final Log log = LogFactory.getLog(MessageServer.class);
    protected ProtocolCodecFilter codec;
    protected static final int MAX_MESSAGE_SIZE = 0x1400000;
    protected IoAcceptor acceptor;
    private static Random random = new Random();
    private MessageFactory factory;
    private long timeout;
    private Timer timer;
    private boolean isRunning = true;
    private Map receivers;
    private Map tasks;

    public MessageServer(int udpPort, MessageFactory factory, long timeout) throws SocketException {
        this.factory = factory;
        this.timeout = timeout;
        this.timer = new Timer(true);
        this.receivers = new HashMap();
        this.tasks = new HashMap();
        ObjectSerializationCodecFactory serialization = new ObjectSerializationCodecFactory();
        serialization.setDecoderMaxObjectSize(0x1400000);
        this.codec = new ProtocolCodecFilter((ProtocolCodecFactory)serialization);
        this.acceptor = new NioSocketAcceptor();
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)this.codec);
        this.acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        MyHandler handler = new MyHandler(this);
        this.acceptor.setHandler((IoHandler)handler);
        try {
            this.acceptor.bind((SocketAddress)new InetSocketAddress(udpPort));
        }
        catch (IOException e) {
            log.error((Object)("unable to bind acceptor on port " + udpPort), (Throwable)e);
            throw new SocketException("unable to bind acceptor on port " + udpPort + e);
        }
    }

    public synchronized int send(Message message, InetAddress ip, int port, Receiver recv) throws IOException {
        if (!this.isRunning) {
            throw new IllegalStateException("MessageServer not running");
        }
        int comm = random.nextInt();
        if (recv != null) {
            Integer key = new Integer(comm);
            this.receivers.put(key, recv);
            TimeoutTask task = new TimeoutTask(comm, recv);
            this.timer.schedule((TimerTask)task, this.timeout);
            this.tasks.put(key, task);
        }
        this.sendMessage(comm, message, ip, port);
        return comm;
    }

    public synchronized void reply(int comm, Message message, InetAddress ip, int port) throws IOException {
        if (!this.isRunning) {
            throw new IllegalStateException("MessageServer not running");
        }
        this.sendMessage(comm, message, ip, port);
    }

    private void sendMessage(int comm, Message message, InetAddress ip, int port) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeInt(comm);
        dout.writeByte(message.code());
        message.toStream(dout);
        dout.close();
        byte[] data = bout.toByteArray();
        NioSocketConnector connector = new NioSocketConnector();
        connector.setConnectTimeoutMillis(10000L);
        connector.getFilterChain().addLast("codec", (IoFilter)this.codec);
        connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        connector.setHandler((IoHandler)new IoHandlerAdapter());
        IoSession session = null;
        InetSocketAddress dest = new InetSocketAddress(ip, port);
        try {
            ConnectFuture future = connector.connect((SocketAddress)dest);
            future.awaitUninterruptibly();
            session = future.getSession();
            log.debug((Object)("send " + data.length + " bytes"));
            WriteFuture future2 = session.write((Object)data);
            future2.awaitUninterruptibly();
        }
        catch (RuntimeIoException e) {
            log.error((Object)("unable to connect to " + dest), (Throwable)e);
            throw new IOException(e);
        }
        finally {
            connector.dispose();
        }
    }

    private synchronized void unregister(int comm) {
        Integer key = new Integer(comm);
        this.receivers.remove(key);
        this.tasks.remove(key);
    }

    public synchronized void close() {
        if (!this.isRunning) {
            throw new IllegalStateException("MessageServer not running");
        }
        this.isRunning = false;
        this.acceptor.dispose();
        this.timer.cancel();
        this.receivers.clear();
        this.tasks.clear();
    }

    class TimeoutTask
    extends TimerTask {
        private int comm;
        private Receiver recv;

        public TimeoutTask(int comm, Receiver recv) {
            this.comm = comm;
            this.recv = recv;
        }

        @Override
        public void run() {
            try {
                MessageServer.this.unregister(this.comm);
                this.recv.timeout(this.comm);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected class MyHandler
    extends IoHandlerAdapter {
        protected MessageServer messageServer;

        public MyHandler(MessageServer messageServer2) {
            this.messageServer = messageServer2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(IoSession session, Object msg) throws Exception {
            ByteArrayInputStream bin = new ByteArrayInputStream((byte[])msg);
            log.debug((Object)("message received (" + bin.available() + " bytes)"));
            DataInputStream din = new DataInputStream(bin);
            int comm = din.readInt();
            byte messCode = din.readByte();
            Message message = MessageServer.this.factory.createMessage(messCode, din);
            din.close();
            Receiver recv = null;
            recv = MessageServer.this.factory.createReceiver(messCode, this.messageServer);
            if (recv == null) {
                MyHandler myHandler = this;
                synchronized (myHandler) {
                    Integer key = new Integer(comm);
                    recv = (Receiver)MessageServer.this.receivers.remove(key);
                    if (recv != null) {
                        TimerTask task = (TimerTask)MessageServer.this.tasks.remove(key);
                        task.cancel();
                    }
                }
            }
            if (recv != null) {
                recv.receive(message, comm);
            }
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            log.error((Object)("exception caught network " + cause));
        }
    }
}

