/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.messaging.Streamable;

public class Node
implements Streamable {
    public static final Comparator LASTSEEN_COMPARATOR = new LastSeenComparator();
    public static final Comparator FIRSTSEEN_COMPARATOR = new FirstSeenComparator();
    private InetAddress ip;
    private int port;
    private Identifier id;
    private long lastSeen;
    private long firstSeen;
    private int failCount = 0;
    private int contactPort = 0;

    public Node(InetAddress ip, int port, Identifier id) {
        this(ip, port, 0, id);
    }

    public Node(InetAddress ip, int port, int contactPort, Identifier id) {
        this.ip = ip;
        this.port = port;
        this.contactPort = contactPort;
        this.id = id;
        this.firstSeen = System.currentTimeMillis();
        this.seenNow();
    }

    public Node(DataInput in) throws IOException {
        this.fromStream(in);
    }

    @Override
    public void fromStream(DataInput in) throws IOException {
        this.id = new Identifier(in);
        byte[] a = new byte[4];
        in.readFully(a);
        this.ip = InetAddress.getByAddress(a);
        this.port = in.readShort() & 0xFFFF;
        this.contactPort = in.readInt();
        this.firstSeen = System.currentTimeMillis();
        this.seenNow();
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        this.id.toStream(out);
        byte[] a = this.ip.getAddress();
        if (a.length != 4) {
            throw new RuntimeException("Expected InetAddress of 4 bytes, got " + a.length);
        }
        out.write(a);
        out.writeShort((short)this.port);
        out.writeInt(this.contactPort);
    }

    public void seenNow() {
        this.lastSeen = System.currentTimeMillis();
        this.failCount = 0;
    }

    public long firstSeen() {
        return this.firstSeen;
    }

    public long lastSeen() {
        return this.lastSeen;
    }

    public InetAddress getInetAddress() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public Identifier getId() {
        return this.id;
    }

    public int getContactPort() {
        return this.contactPort;
    }

    public void setContactPort(int contactPort) {
        this.contactPort = contactPort;
    }

    public int incFailCount() {
        return ++this.failCount;
    }

    public boolean equals(Object o) {
        if (o instanceof Node) {
            return this.id.equals(((Node)o).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Node[ip=" + this.ip.getHostAddress() + ",port=" + this.port + ",id=" + this.id + "]";
    }

    public static Node[] sort(Collection nodes, Identifier rel) {
        Node[] sorted = new Node[nodes.size()];
        sorted = nodes.toArray(sorted);
        Arrays.sort(sorted, new DistanceComparator(rel));
        return sorted;
    }

    public static class FirstSeenComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Node n1 = (Node)o1;
            Node n2 = (Node)o2;
            return (int)(n1.firstSeen - n2.firstSeen);
        }
    }

    public static class LastSeenComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Node n1 = (Node)o1;
            Node n2 = (Node)o2;
            return (int)(n1.lastSeen - n2.lastSeen);
        }
    }

    public static class DistanceComparator
    implements Comparator {
        private BigInteger relval;

        public DistanceComparator(Identifier relId) {
            this.relval = relId.value();
        }

        public int compare(Object o1, Object o2) {
            Node n1 = (Node)o1;
            Node n2 = (Node)o2;
            BigInteger distance1 = this.relval.xor(n1.id.value());
            BigInteger distance2 = this.relval.xor(n2.id.value());
            return distance1.compareTo(distance2);
        }
    }
}

