/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.planx.xmlstore.routing.Configuration;
import org.planx.xmlstore.routing.DistributedMap;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.NeighbourhoodListener;
import org.planx.xmlstore.routing.NeighbourhoodListenerImpl;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.RoutingException;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.TimestampedValue;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.operation.ConnectOperation;
import org.planx.xmlstore.routing.operation.DataLookupOperation;
import org.planx.xmlstore.routing.operation.MessageFactoryImpl;
import org.planx.xmlstore.routing.operation.Operation;
import org.planx.xmlstore.routing.operation.RemoveOperation;
import org.planx.xmlstore.routing.operation.ResponsibleOperation;
import org.planx.xmlstore.routing.operation.RestoreOperation;
import org.planx.xmlstore.routing.operation.StoreOperation;

public class Kademlia
implements DistributedMap {
    private static final Log log = LogFactory.getLog(Kademlia.class);
    private Configuration conf;
    private Map localMap;
    private String name;
    private Node local;
    private Space space;
    private MessageServer server;
    private Timer timer;
    private boolean isClosed = false;

    public Kademlia(Identifier id, int udpPort) throws IOException, RoutingException {
        this(null, id, udpPort, 0, null, null);
    }

    public Kademlia(Identifier id, int udpPort, Configuration config) throws IOException, RoutingException {
        this(null, id, udpPort, 0, null, config);
    }

    public Kademlia(String name, int udpPort, int contactPort, InetSocketAddress bootstrap) throws IOException, RoutingException {
        this(name, null, udpPort, contactPort, bootstrap, null);
    }

    public Kademlia(String name, int udpPort, int contactPort, InetSocketAddress bootstrap, Configuration config) throws IOException, RoutingException {
        this(name, null, udpPort, contactPort, bootstrap, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Kademlia(String name, Identifier defaultId, int udpPort, int contactPort, InetSocketAddress bootstrap, Configuration config) throws IOException, RoutingException {
        InetAddress actualIP;
        Configuration configuration = this.conf = config == null ? new Configuration() : config;
        if (defaultId == null) {
            defaultId = Identifier.randomIdentifier();
        }
        Identifier id = defaultId;
        this.localMap = new Hashtable();
        this.name = name;
        if (name != null) {
            id = this.initFromDisk(defaultId);
        }
        if ((actualIP = InetAddress.getLocalHost()).isLoopbackAddress()) {
            Socket temp = null;
            try {
                temp = new Socket("example.com", 80);
                actualIP = temp.getLocalAddress();
            }
            catch (IOException e) {
                log.debug((Object)"can't open socket to public IP", (Throwable)e);
            }
            finally {
                if (temp != null) {
                    temp.close();
                }
            }
        }
        this.local = new Node(actualIP, udpPort, contactPort, id);
        NeighbourhoodListenerImpl listener = new NeighbourhoodListenerImpl(this.local);
        this.space = new Space(this.local, this.conf, listener);
        MessageFactoryImpl factory = new MessageFactoryImpl(this.localMap, this.local, this.space);
        this.server = new MessageServer(udpPort, factory, this.conf.RESPONSE_TIMEOUT);
        listener.setMessageServer(this.server);
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    RestoreOperation op = new RestoreOperation(Kademlia.this.conf, Kademlia.this.server, Kademlia.this.space, Kademlia.this.local, Kademlia.this.localMap);
                    ((Operation)op).execute();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, this.conf.RESTORE_INTERVAL, this.conf.RESTORE_INTERVAL);
        if (bootstrap != null) {
            this.connect(bootstrap);
        }
    }

    private Identifier initFromDisk(Identifier defaultId) {
        InputStream in;
        Identifier id = null;
        try {
            String idname = this.name + ".id";
            in = new DataInputStream(new FileInputStream(idname));
            id = new Identifier((DataInput)((Object)in));
            ((FilterInputStream)in).close();
        }
        catch (IOException e) {
            id = defaultId;
        }
        try {
            String mapname = this.name + ".map";
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(mapname)));
            this.localMap = (Hashtable)((ObjectInputStream)in).readObject();
            ((ObjectInputStream)in).close();
        }
        catch (IOException e) {
            this.localMap = new Hashtable();
        }
        catch (ClassNotFoundException e) {
            this.localMap = new Hashtable();
        }
        return id;
    }

    private void stateToDisk() throws IOException {
        String idname = this.name + ".id";
        DataOutputStream dout = new DataOutputStream(new FileOutputStream(idname));
        this.local.getId().toStream(dout);
        dout.close();
        String mapname = this.name + ".map";
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(mapname)));
        out.writeObject(this.localMap);
        out.close();
    }

    public void connect(InetSocketAddress bootstrap) throws IOException, RoutingException {
        if (this.isClosed) {
            throw new IllegalStateException("Kademlia instance is closed");
        }
        ConnectOperation op = new ConnectOperation(this.conf, this.server, this.space, this.local, bootstrap.getAddress(), bootstrap.getPort());
        ((Operation)op).execute();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("Kademlia instance is closed");
        }
        this.isClosed = true;
        this.timer.cancel();
        this.server.close();
        if (this.name != null) {
            this.stateToDisk();
        }
    }

    @Override
    public boolean contains(Identifier key) throws IOException, RoutingException {
        if (this.isClosed) {
            throw new IllegalStateException("Kademlia instance is closed");
        }
        return this.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable get(Identifier key) throws IOException, RoutingException {
        if (this.isClosed) {
            throw new IllegalStateException("Kademlia instance is closed");
        }
        Map map = this.localMap;
        synchronized (map) {
            if (this.localMap.containsKey(key)) {
                return ((TimestampedValue)this.localMap.get(key)).getObject();
            }
        }
        DataLookupOperation op = new DataLookupOperation(this.conf, this.server, this.space, this.local, key);
        return (Serializable)((Operation)op).execute();
    }

    @Override
    public void put(Identifier key, Serializable value) throws IOException, RoutingException {
        if (this.isClosed) {
            throw new IllegalStateException("Kademlia instance is closed");
        }
        long now = System.currentTimeMillis();
        TimestampedValue timeval = new TimestampedValue(value, now);
        StoreOperation op = new StoreOperation(this.conf, this.server, this.space, this.localMap, this.local, key, timeval);
        ((Operation)op).execute();
    }

    @Override
    public void remove(Identifier key) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("Kademlia instance is closed");
        }
        RemoveOperation op = new RemoveOperation(this.conf, this.server, this.space, this.localMap, this.local, key);
        ((Operation)op).execute();
    }

    @Override
    public int getContactPort() {
        return this.local.getContactPort();
    }

    @Override
    public void setContactPort(int port) {
        this.local.setContactPort(port);
    }

    @Override
    public List responsiblePeers(Identifier key) throws IOException, RoutingException {
        ResponsibleOperation op = new ResponsibleOperation(this.conf, this.server, this.space, this.local, key);
        List peers = (List)((Operation)op).execute();
        return peers;
    }

    @Override
    public void addNeighbourhoodListener(NeighbourhoodListener listener) {
        this.space.addNeighbourhoodListener(listener);
    }

    @Override
    public void removeNeighbourhoodListener(NeighbourhoodListener listener) {
        this.space.removeNeighbourhoodListener(listener);
    }

    public String toString() {
        return this.local.getInetAddress().toString() + ":" + this.local.getPort() + ", " + "map size=" + this.localMap.size() + ", " + "space size=" + this.space.nodeCount();
    }

    Space internalGetSpace() {
        return this.space;
    }

    Node internalGetLocal() {
        return this.local;
    }

    Map internalGetMap() {
        return this.localMap;
    }
}

