/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.regions;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.io.PersistentMap;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.nodes.SystemNode;
import org.planx.xmlstore.references.AbstractReferenceListener;
import org.planx.xmlstore.references.ContentValueReference;
import org.planx.xmlstore.references.ReferenceListener;
import org.planx.xmlstore.regions.Region;
import org.planx.xmlstore.regions.RegionManager;
import org.planx.xmlstore.regions.Sharer;

public class HashSharer
extends Sharer {
    private LinkedList<Region> regions;
    private LinkedList<Region> queue;
    private ReferenceListener listener;
    private Map<ContentValueReference, SystemNode> discMap;
    private PersistentMap<ContentValueReference, LocalLocator> refTable;

    HashSharer(RegionManager manager) throws IOException {
        super(manager);
        String name = manager.getXMLStore().toString();
        this.regions = new LinkedList();
        this.queue = new LinkedList();
        Streamer<ContentValueReference> s1 = ContentValueReference.getStreamer();
        Streamer<LocalLocator> s2 = LocalLocator.getStreamer(false);
        this.refTable = new PersistentMap<ContentValueReference, LocalLocator>(name + ".hash", s1, s2);
        this.listener = new HashListener();
    }

    @Override
    synchronized void addRegion(Region region) throws IOException, UnknownReferenceException {
        if (region == null) {
            throw new NullPointerException();
        }
        this.share(region);
        this.regions.addLast(region);
    }

    @Override
    synchronized void removeRegion(Region region) {
        this.regions.remove(region);
        this.queue.remove(region);
    }

    @Override
    public synchronized void share() throws IOException, UnknownReferenceException {
        Region r = this.queue.poll();
        if (r == null) {
            this.queue.addAll(this.regions);
            return;
        }
        this.share(r);
    }

    public synchronized void share(Region r) throws IOException, UnknownReferenceException {
        ++this.invocations;
        if (!r.isClosed()) {
            throw new IllegalArgumentException("Region is not closed");
        }
        SystemNode root = r.getRegionRoot(null);
        this.discMap = new HashMap<ContentValueReference, SystemNode>();
        this.discriminate(root, r, new Object());
        this.discMap = null;
        r.persist();
        Object visitToken = new Object();
        for (SystemNode node : root.getChildren()) {
            this.updateTable(node, r, visitToken);
        }
        r.prepareMend(null);
        boolean isConsistent = r.mend(null);
        assert (r.assertInterRegion()) : "inter-region inconsistency";
        r.releaseRegionRoot();
        if (!isConsistent) {
            this.share(r);
        }
    }

    private synchronized void discriminate(SystemNode node, Region r, Object visitToken) throws IOException {
        if (!r.isContained(node.getLocator())) {
            return;
        }
        if (node.getVisitToken() == visitToken) {
            return;
        }
        node.setVisitToken(visitToken);
        List<SystemNode> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            SystemNode child = children.get(i);
            this.discriminate(child, r, visitToken);
            ContentValueReference vref = ContentValueReference.reference(child, this.listener);
            SystemNode existing = this.discMap.get(vref);
            if (existing == null) {
                this.discMap.put(vref, child);
                continue;
            }
            node.setChild(i, existing);
        }
    }

    private synchronized void updateTable(SystemNode node, Region r, Object visitToken) throws IOException {
        if (!r.isContained(node.getLocator())) {
            return;
        }
        if (node.getVisitToken() == visitToken) {
            return;
        }
        node.setVisitToken(visitToken);
        ContentValueReference vref = (ContentValueReference)node.getReference();
        this.refTable.put(vref, node.getLocator());
        for (SystemNode child : node.getChildren()) {
            this.updateTable(child, r, visitToken);
        }
    }

    private class HashListener
    extends AbstractReferenceListener {
        private HashListener() {
        }

        @Override
        public ContentValueReference lookup(Node node) {
            SystemNode n = (SystemNode)node;
            if (n.getReference() instanceof ContentValueReference) {
                return (ContentValueReference)n.getReference();
            }
            return null;
        }

        @Override
        public void referenceComputed(Node node, ContentValueReference vref) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (vref == null) {
                throw new NullPointerException();
            }
            SystemNode n = (SystemNode)node;
            if (n.getLocator() == null) {
                throw new NullPointerException();
            }
            LocalLocator existing = (LocalLocator)HashSharer.this.refTable.get(vref);
            if (existing != null) {
                n.setLocator(existing);
            }
            n.setReference(vref);
        }
    }
}

