/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.nameserver;

import java.io.IOException;
import org.planx.xmlstore.NameAlreadyBoundException;
import org.planx.xmlstore.NameServer;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.StaleReferenceException;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.io.PersistentMap;
import org.planx.xmlstore.io.PolymorphicStreamer;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.Streamers;
import org.planx.xmlstore.references.AbstractReferenceListener;
import org.planx.xmlstore.references.Locator;
import org.planx.xmlstore.stores.LocalXMLStore;

public class LocalNameServer
implements NameServer {
    private PersistentMap<String, Reference> map;
    private LocalXMLStore xmlstore;

    public LocalNameServer(LocalXMLStore xmlstore) throws IOException {
        this.xmlstore = xmlstore;
        String name = xmlstore.toString();
        Streamer<String> s1 = Streamers.stringStreamer();
        PolymorphicStreamer<Reference> s2 = Streamers.getPolymorphicStreamer(Reference.class);
        this.map = new PersistentMap<String, Reference>(name + "_nameserver.hash", s1, s2);
        xmlstore.addReferenceListener(new LocalNameListener());
    }

    @Override
    public Reference lookup(String docName) {
        return this.map.get(docName);
    }

    @Override
    public void bind(String name, Reference ref) throws IOException, NameAlreadyBoundException {
        try {
            Reference tmp = this.lookup(name);
            if (tmp != null && tmp.equals(ref)) {
                return;
            }
            if (tmp != null) {
                throw new NameAlreadyBoundException(name, ref);
            }
            this.map.put(name, ref);
            this.xmlstore.retain(ref);
        }
        catch (UnknownReferenceException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public void rebind(String name, Reference oldr, Reference newr) throws IOException, StaleReferenceException {
        try {
            Reference tmp = this.lookup(name);
            if (tmp != null && !tmp.equals(oldr)) {
                throw new StaleReferenceException(name, oldr, tmp);
            }
            this.map.put(name, newr);
            this.xmlstore.retain(newr);
            this.xmlstore.release(oldr);
        }
        catch (UnknownReferenceException e) {
            throw new IOException(e.toString());
        }
    }

    private class LocalNameListener
    extends AbstractReferenceListener {
        private LocalNameListener() {
        }

        @Override
        public void referenceMoved(Locator oldLoc, Locator newLoc) {
            try {
                LocalNameServer.this.map.replace(oldLoc, newLoc);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

