/*
 * Decompiled with CFR 0.152.
 */
package org.planx.util;

import java.util.AbstractList;
import java.util.List;
import org.planx.util.Association;
import org.planx.util.Pair;

public final class Pairs {
    private Pairs() {
    }

    public static <E> List<Pair<E, E>> identityPairs(E[] values) {
        return new ArrayIdentityPairs<E>(values);
    }

    public static <E> List<Pair<E, E>> identityPairs(List<? extends E> values) {
        return new IdentityPairsList<E>(values);
    }

    public static <E, F> List<Pair<E, F>> mergePairs(E[] labels, F[] values) {
        return new ArrayMergePairs<E, F>(labels, values);
    }

    public static <E, F> List<Pair<E, F>> mergePairs(List<? extends E> labels, List<? extends F> values) {
        return new MergePairsList<E, F>(labels, values);
    }

    public static <E, F> List<E> retainFirst(List<? extends Pair<? extends E, ? extends F>> pairs) {
        return new FilterFirstList(pairs);
    }

    public static <E, F> List<F> retainSecond(List<? extends Pair<? extends E, ? extends F>> pairs) {
        return new FilterSecondList(pairs);
    }

    private static class FilterSecondList<E, F>
    extends AbstractList<F> {
        private final List<? extends Pair<? extends E, ? extends F>> values;

        FilterSecondList(List<? extends Pair<? extends E, ? extends F>> values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public F get(int index) {
            Pair<? extends E, ? extends F> pair = this.values.get(index);
            return pair == null ? null : (F)pair.getSecond();
        }
    }

    private static class FilterFirstList<E, F>
    extends AbstractList<E> {
        private final List<? extends Pair<? extends E, ? extends F>> values;

        FilterFirstList(List<? extends Pair<? extends E, ? extends F>> values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public E get(int index) {
            Pair<? extends E, ? extends F> pair = this.values.get(index);
            return pair == null ? null : (E)pair.getFirst();
        }
    }

    private static class MergePairsList<E, F>
    extends AbstractList<Pair<E, F>> {
        private final List<? extends E> labels;
        private final List<? extends F> values;

        MergePairsList(List<? extends E> labels, List<? extends F> values) {
            this.labels = labels;
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public Pair<E, F> get(int index) {
            return new Association<E, F>(this.labels.get(index), this.values.get(index));
        }
    }

    private static class ArrayMergePairs<E, F>
    extends AbstractList<Pair<E, F>> {
        private final E[] labels;
        private final F[] values;

        ArrayMergePairs(E[] labels, F[] values) {
            this.labels = labels;
            this.values = values;
        }

        @Override
        public int size() {
            return this.labels.length;
        }

        @Override
        public Pair<E, F> get(int index) {
            return new Association<E, F>(this.labels[index], this.values[index]);
        }
    }

    private static class IdentityPairsList<E>
    extends AbstractList<Pair<E, E>> {
        private final List<? extends E> values;

        IdentityPairsList(List<? extends E> values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public Pair<E, E> get(int index) {
            E elm = this.values.get(index);
            return new Association<E, E>(elm, elm);
        }
    }

    private static class ArrayIdentityPairs<E>
    extends AbstractList<Pair<E, E>> {
        private final E[] values;

        ArrayIdentityPairs(E[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public Pair<E, E> get(int index) {
            E elm = this.values[index];
            return new Association<E, E>(elm, elm);
        }
    }
}

