/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.number;

import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.number.NumberDiscriminator;

public class DoubleDiscriminator
extends NumberDiscriminator<Double> {
    public DoubleDiscriminator(Memory memory) {
        super(memory);
    }

    @Override
    protected int bitsize() {
        return 64;
    }

    @Override
    protected <U> NumberDiscriminator.ChunkExtractor<U> chunkExtractor(Extractor<U, ? extends Double, ?> e) {
        return new NumberDiscriminator.ChunkExtractor<U>(e){

            @Override
            public int getLabel(U elm) {
                Double value = (Double)this.e.getLabel(elm);
                return (int)(Double.doubleToLongBits(value) >> this.offset & 0xFFFFL);
            }
        };
    }
}

