/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.Discriminators;
import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.number.IntExtractor;
import org.planx.msd.number.IntegerDiscriminator;
import org.planx.msd.util.AbstractDiscriminator;
import org.planx.util.Array;

public class SizeRandomAccessListDiscriminator<T>
extends AbstractDiscriminator<List<T>> {
    private static final int INIT_CAPACITY = 10;
    private Discriminator<T> disc;
    private IntegerDiscriminator intDisc;

    public SizeRandomAccessListDiscriminator(Discriminator<T> d, Memory memory) {
        this.disc = d;
        this.intDisc = new IntegerDiscriminator(memory);
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, final Extractor<U, ? extends List<T>, S> e) {
        int vsize = values.size();
        if (vsize == 0) {
            return Collections.emptyList();
        }
        if (vsize == 1) {
            List<S> l1 = Collections.singletonList(e.getValue(values.get(0)));
            return Collections.singletonList(l1);
        }
        ArrayList<List<S>> result = new ArrayList<List<S>>();
        ElementExtractor ext = new ElementExtractor(e);
        int[] indexes = new int[10];
        List[] work = new List[10];
        int work_capacity = 10;
        int work_head = 0;
        IntExtractor intExt = new IntExtractor<U, U>(){

            @Override
            public int getLabel(U elm) {
                return ((List)e.getLabel(elm)).size();
            }

            @Override
            public U getValue(U elm) {
                return elm;
            }
        };
        Collection partition = this.intDisc.discriminate(values, intExt);
        for (List block : partition) {
            if (block.size() > 1) {
                if (work_head + 1 >= work_capacity) {
                    work = Array.ensureCapacity(work, work_head, work_capacity + 1);
                    indexes = Array.ensureCapacity(indexes, work_head, work_capacity + 1);
                    work_capacity = work.length;
                }
                work[work_head] = block;
                ++work_head;
                continue;
            }
            result.add(Discriminators.valueList(block, e));
        }
        while (work_head > 0) {
            if (work_head < work_capacity) {
                work[work_head] = null;
            }
            List block = work[--work_head];
            int index = indexes[work_head];
            if (e.getLabel(block.get(0)).size() > index) {
                ext.index = index++;
                partition = this.disc.discriminate(block, ext);
                for (List subBlock : partition) {
                    if (subBlock.size() > 1) {
                        if (work_head + 1 >= work_capacity) {
                            work = Array.ensureCapacity(work, work_head, work_capacity + 1);
                            indexes = Array.ensureCapacity(indexes, work_head, work_capacity + 1);
                            work_capacity = work.length;
                        }
                        work[work_head] = subBlock;
                        indexes[work_head] = index;
                        ++work_head;
                        continue;
                    }
                    result.add(Discriminators.valueList(subBlock, e));
                }
                continue;
            }
            result.add(Discriminators.valueList(block, e));
        }
        return result;
    }

    private static class ElementExtractor<E, F>
    implements Extractor<E, F, E> {
        private Extractor<E, ? extends List<F>, ?> e;
        public int index = 0;

        public ElementExtractor(Extractor<E, ? extends List<F>, ?> e) {
            this.e = e;
        }

        @Override
        public F getLabel(E elm) {
            List<F> list = this.e.getLabel(elm);
            return list.get(this.index);
        }

        @Override
        public E getValue(E elm) {
            return elm;
        }
    }
}

