package org.planx.xpath.function;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.object.*;

/**
 * Core position function.
 **/
public class PositionFunction implements Function {
    public XObject evaluate(XObject[] args, Context ctxt, Environment env,
                                  Navigator nav) throws FunctionException {
        if (args.length == 0) {
            return new XNumber((double) ctxt.getPosition());
        } else {
            throw new FunctionException("Illegal number of arguments");
        }
    }
}
