package org.planx.xpath.expr.operator;

import org.planx.xpath.expr.Expression;

/**
 * Greater than or equal than operator
 **/
public class GreaterOrEqualOperator extends RelationalOperator {
    public GreaterOrEqualOperator(Expression e1, Expression e2) {
        super(e1, e2);
    }

    protected boolean compare(double v1, double v2) {
        return v1 >= v2;
    }

    protected boolean compareSets(double v1_min, double v1_max,
                                  double v2_min, double v2_max) {
        return v1_max >= v2_min;
    }

    protected String operatorName() {
        return ">=";
    }
}
