package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;

public class ParentAxis extends Axis {
    public ParentAxis() {
    }

    public AxisIterator iterator(Object contextNode, Navigator navigator)
                                                  throws XPathException {
        return new ParentAxisIterator(contextNode, navigator);
    }

    /**
     * The principal node type of this axis is
     * {@link Navigator#ELEMENT}.
     **/
    public int getPrincipalNodeType() {
        return Navigator.ELEMENT;
    }

    public boolean isReverse() {
        return false;
    }

    public String toString() {
        return "parent";
    }

    class ParentAxisIterator implements AxisIterator {
        private Object parentNode = null;
        private XPathException parentException = null;
        private boolean isDone = false;

        ParentAxisIterator(Object contextNode, Navigator navigator)
                                            throws XPathException {
            try {
                parentNode = navigator.getParent(contextNode);
            } catch (XPathException e) {
                // delay the throwing of the exception until
                // the node is actually requested
                parentException = e;
            }
        }

        public boolean hasNext() {
            return !isDone && (parentNode != null);
        }

        public Object next() throws XPathException {
            if (isDone) throw new XPathException(
                  "No more elements in iterator");
            if (parentException != null) throw parentException;
            isDone = true;
            return parentNode;
        }
    }
}
