package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;

/**
 * Contains all the following siblings of the context node.
 * If the context node is an attribute node the following-sibling
 * axis is empty.
 **/
public class FollowingSiblingAxis extends Axis {
    public FollowingSiblingAxis() {}

    public AxisIterator iterator(Object contextNode, Navigator navigator)
                                                   throws XPathException {
        return new FollowingSiblingAxisIterator(contextNode, navigator);
    }

    /**
     * The principal node type of this axis is
     * {@link Navigator#ELEMENT}.
     **/
    public int getPrincipalNodeType() {
        return Navigator.ELEMENT;
    }

    public boolean isReverse() {
        return false;
    }

    public String toString() {
        return "following-sibling";
    }

    class FollowingSiblingAxisIterator implements AxisIterator {
        private Object currentNode = null;
        private Navigator navigator;
        private XPathException currentException = null;

        FollowingSiblingAxisIterator(Object contextNode, Navigator navigator)
                                                      throws XPathException {
            this.navigator = navigator;
            int type = navigator.getType(contextNode);
            if (type != Navigator.ATTRIBUTE) {
                this.currentNode = contextNode;
                next();
            }
        }

        public boolean hasNext() {
            return currentNode != null;
        }

        public Object next() throws XPathException {
            if (currentException != null) throw currentException;
            if (currentNode == null) throw new XPathException(
                               "No more elements in iterator");
            Object result = currentNode;
            try {
                currentNode = navigator.nextSibling(currentNode);
            } catch (XPathException e) {
                // delay the throwing of the exception until
                // the node is actually requested
                currentException = e;
                currentNode = null;
            }
            return result;
        }
    }
}
