package org.planx.xmlstore.stores;

import java.io.IOException;
import java.util.concurrent.*;
import org.planx.xmlstore.*;
import org.planx.xmlstore.nodes.*;
import org.planx.xmlstore.util.Concurrency;

/**
 * @author Kasper Bøgebjerg
 * @author Henning Niss
 * @author Thomas Ambus
 */
public class OptimisticReadXMLStore extends AbstractXMLStore {
    public OptimisticReadXMLStore(XMLStore xmlstore) {
        super(xmlstore);
    }

    public Node load(final Reference vref) throws IOException,
                                    UnknownReferenceException {
        checkClosed();
        Callable<SystemNode> callable = new Callable<SystemNode>() {
            public SystemNode call() throws IOException, UnknownReferenceException {
                return (SystemNode) xmlstore.load(vref);
            }
        };
        Future<SystemNode> future = Concurrency.localExecutor().submit(callable);
        return new BlockingNodeProxy(vref, future);
    }
}
