package org.planx.xmlstore;

import java.util.List;
import org.planx.xmlstore.*;
import org.planx.xmlstore.io.*;
import org.planx.xmlstore.nodes.*;
import org.planx.xmlstore.references.*;

/**
 * @author Kasper Bøgebjerg
 * @author Henning Niss
 * @author Thomas Ambus
 */
public abstract class NodeFactory {
    private static NodeFactory instance = null;

    protected NodeFactory() {}

    public static NodeFactory instance() {
        if (instance == null) instance = new DVMNodeFactory();
        return instance;
    }

    public abstract Attribute createAttribute(String name, String value);

    public abstract Node createElementNode(String tagName);

    public abstract Node createElementNode(String tagName, List<? extends Node> children);

    public abstract Node createElementNode(String tagName, List<? extends Node> children,
                                                                  List<Attribute> attrs);

    public abstract Node createElementNode(String tagName, Node[] children);

    public abstract Node createElementNode(String tagName, Node[] children, Attribute[] attrs);

    public abstract Node createElementNode(String tagName, Node child);

    public abstract Node createCharDataNode(String data);

    /**
     * The method is used for replacing a child of an element node. The
     * replacement is done by constructing and returning a new element node,
     * which only differs from the original element node in the replaced
     * child.
     *
     * @param  node element node.
     * @param  index index of the child to replace.
     * @param  child new child node.
     * @return  new element node.
     */
    public abstract Node replaceChild(Node node, int index, Node child);

    /**
     * The method is used for adding a child to an element node. This is
     * done by constructing and returning a new element node, which only
     * differs from the original element node in the added child.
     *
     * @param  n     element node.
     * @param  index index at which new child is inserted.
     * @param  child new child node.
     * @return new element node.
     */
    public abstract Node insertChild(Node n, int index, Node child);

    /**
     * The method is used for removing a child from an element node. This is
     * done by constructing and returning a new element node, which only
     * differs from the original element node in the removed child.
     *
     * @param  n     element node.
     * @param  index index specifying the child to remove
     * @return new element node.
     */
    public abstract Node removeChild(Node n, int index);
}
