package org.planx.msd.util;

import java.util.Collection;
import java.util.List;
import org.planx.msd.*;

/**
 * This class provides a skeletal implementation of a
 * <code>Discriminator</code>.
 *
 * @author Thomas Ambus
 */
public abstract class AbstractDiscriminator<T> implements Discriminator<T> {
    protected AbstractDiscriminator() {}

    public <S extends T> Collection<List<S>> discriminate(List<S> values) {
        Extractor<S,S,S> e = Discriminators.identityExtractor();
        return discriminate(values, e);
    }

    public abstract <U,S> Collection<List<S>> discriminate(
                        List<? extends U> values,
                        Extractor<U,? extends T,S> e);
}
