package org.planx.msd;

import java.util.Collection;
import java.util.List;

/**
 * A multiset discriminator. For further information please see the
 * <a href="package-summary.html#package_description">Package Summary</a>.
 *
 * @author Thomas Ambus
 */
public interface Discriminator<T> {
    /**
     * Discriminates a <code>List</code> of values, and returns a
     * <code>Collection</code> of <code>List</code>s, each representing
     * an equivalence class containing elements
     * from <code>values</code> that are equivalent.
     * <p>
     * The <code>Collection</code> of <code>List</code>s returned should
     * be considered unmodifiable (though, in some cases they might actually
     * be modifiable, but this behaviour should not be relied upon).
     */
    public <S extends T> Collection<List<S>> discriminate(List<S> values);

    /**
     * Discriminates a <code>List</code> of values using an <code>Extractor</code>,
     * and returns a <code>Collection</code> of <code>List</code>s, each
     * representing an equivalence class containing elements from
     * <code>values</code> that are equivalent.
     * The <code>Extractor</code> performs the task of extracting two kinds
     * of objects from the input <code>values</code>: The <i>label</i> which
     * is the object equivalence is defined upon, and the <i>value</i> which
     * is the object that will be returned. That is, the <i>label</i>
     * determines which equivalence class the <i>value</i> goes into.
     * <p>
     * The <code>Collection</code> of <code>List</code>s returned should be
     * considered unmodifiable (though, in some cases they might actually be
     * modifiable, but this behaviour should not be relied upon).
     */
    public <U,S> Collection<List<S>> discriminate(List<? extends U> values,
                                              Extractor<U,? extends T,S> e);
}
