package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;

public class AnyAxis extends DescendantAxis {
    public AnyAxis() {}

    public AxisIterator iterator(Object contextNode, Navigator navigator)
                                                  throws XPathException {
        Object root = navigator.getRoot(contextNode);
        return new DescendantAxisIterator(root, navigator, true);
    }

    public boolean isReverse() {
        return false;
    }

    public String toString() {
        return "any";
    }
}
