package org.planx.xpath.expr;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;

/**
 * Represents a name test.
 **/
public class NameTest extends NodeTest {
    private String name;

    public NameTest(String name) {
        if (name == null) throw new NullPointerException();
        this.name = name;
    }

    /**
     * Returns <code>true</code> if the node is of the
     * principal node type and has a name that matches
     * this name test.
     **/
    public boolean matches(Object node, int principalNodeType,
                   Navigator navigator) throws XPathException {
        return (navigator.getType(node) == principalNodeType) &&
               name.equals(navigator.getName(node));
    }

    public String toString() {
        return name;
    }
}
