package org.planx.xpath.expr;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.object.*;

/**
 * Represents a filter expression with predicates.
 **/
public class FilterExpression extends Expression {
    private final Expression expr;
    private final PredicateList predicates;

    public FilterExpression(Expression expr, PredicateList predicates) {
        this.expr = expr;
        this.predicates = predicates;
    }

    public XObject evaluate(Context ctxt, Environment env, Navigator nav)
                                                   throws XPathException {
        try {
            XNodeSet values = (XNodeSet) expr.evaluate(ctxt, env, nav);
            return predicates.evaluate(values, env, nav);
        } catch (ClassCastException e) {
            throw new XPathException("Expression did not evaluate "+
                                     "to an XNodeSet: "+expr);
        }
    }

    public String toString() {
        return expr.toString()+predicates.toString();
    }
}
