package org.planx.xpath;

/**
 * An XPath context.
 **/
public class Context {
    private Object ctxtNode;
    private int ctxtPosition;
    private int ctxtSize;

    /**
     * Create an empty context.
     **/
    public Context() {
        this(null, 0, 0);
    }

    /**
     * Create a context with the context node, context position,
     * and context size.
     **/
    public Context(Object ctxtNode, int ctxtPosition, int ctxtSize) {
        this.ctxtNode = ctxtNode;
        this.ctxtPosition = ctxtPosition;
        this.ctxtSize = ctxtSize;
    }

    /**
     * Returns the context node.
     **/
    public Object getNode() {
        return ctxtNode;
    }

    /**
     * Set the context node.
     **/
    public void setNode(Object ctxtNode) {
        this.ctxtNode = ctxtNode;
    }

    /**
     * Returns the context position of the context node.
     **/
    public int getPosition() {
        return ctxtPosition;
    }

    /**
     * Set the context position.
     **/
    public void setPosition(int ctxtPosition) {
        this.ctxtPosition = ctxtPosition;
    }

    /**
     * Returns the context size.
     **/
    public int getSize() {
        return ctxtSize;
    }

    /**
     * Set the context size.
     **/
    public void setSize(int ctxtSize) {
        this.ctxtSize = ctxtSize;
    }
}
