package org.planx.xmlstore.util;

import java.util.concurrent.*;

/**
 * @author Thomas Ambus
 */
public class Concurrency {
    private static final int  CORE_POOL_SIZE    = 10;
    private static final int  MAXIMUM_POOL_SIZE = 100;
    private static final long KEEP_ALIVE_TIME   = 60;  // seconds
    private static ExecutorService instance = null;

    private Concurrency() {}

    /**
     * Returns a shared <code>ExecutorService</code> for local XMLStore clients.
     */
    public static ExecutorService localExecutor() {
        if (instance == null) {
            instance = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE,
                                              KEEP_ALIVE_TIME, TimeUnit.SECONDS,
                                              new LinkedBlockingQueue<Runnable>());
        }
        return instance;
    }

    /**
     * Returns a shared <code>ExecutorService</code> for remote XMLStore clients.
     */
    public static ExecutorService networkExecutor() {
        return localExecutor();
    }

    /**
     * Returns an already completed <code>Future</code> merely wrapping a value.
     */
    public static <V> Future<V> future(final V elm) {
        return new Future<V>() {
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }
            public V get() {
                return elm;
            }
            public V get(long timeout, TimeUnit unit) {
                return elm;
            }
            public boolean isCancelled() {
                return false;
            }
            public boolean isDone() {
                return true;
            }
        };
    }
}