package org.planx.xmlstore.stores;

import java.io.IOException;
import java.util.*;
import org.planx.xmlstore.*;
import org.planx.xmlstore.io.FileSystem;
import org.planx.util.ThreadPool;

/**
 * @author Henning Niss
 */
public class ReplicatorXMLStore extends AbstractXMLStore {
    private LinkedList xmlstores;

    private ThreadPool _pool; /* a pool to control the number of threads
                                 spawned by this XML Store */
    public ReplicatorXMLStore(LinkedList xmlstores) {
        this.xmlstores = xmlstores;
        this._pool = new ThreadPool();
    }

    public void close() {
    }

    protected void checkClosed() {
    }

    private Reference _saved_vref;

    public synchronized Reference save(Node n) {
        checkClosed();
        System.out.println("Saving value");
        _saved_vref = null;
        Iterator iter = xmlstores.iterator();
        while(iter.hasNext()) {
            XMLStore xmlstore = (XMLStore) iter.next();
            _pool.addWork(new SaveThread(this, xmlstore, n));
        }

        try {
            while (_saved_vref == null) {
                wait();
            }
            return _saved_vref;
        } catch (InterruptedException e) {
            return null;
        }
    }

    protected synchronized void setSaveResult(Reference vref) {
        _saved_vref = vref;
        notify();
    }

    private Node _loaded_node = null;

    public synchronized Node load(Reference vref) {
        checkClosed();
        System.out.println("Loading value");
        _loaded_node = null;
        Iterator iter = xmlstores.iterator();
        while(iter.hasNext()) {
            XMLStore xmlstore = (XMLStore) iter.next();
            _pool.addWork(new LoadThread(this, xmlstore, vref));
        }

        try {
            System.out.println("Waiting ...");
            while (_loaded_node == null) {
                wait();
            }
            System.out.println("Returning ...");
            return _loaded_node;
        } catch (InterruptedException e) {
            return null;
        }
    }

    protected synchronized void setLoadResult(Node node) {
        _loaded_node = node;
        notify();
    }

    private class SaveThread implements Runnable {
        ReplicatorXMLStore owner;
        XMLStore xmlstore;
        Node node;

        public SaveThread(ReplicatorXMLStore owner, XMLStore xmlstore, Node n) {
            this.owner = owner;
            this.xmlstore = xmlstore;
            this.node = n;
        }

        public void run() {
            Reference vref;
            try {
                vref = xmlstore.save(node);
            } catch (IOException e) {
                vref = null; /* FIXME */
            }
            System.out.println("Okay, finally saved");
            owner.setSaveResult(vref);
        }
    }

    private class LoadThread implements Runnable {
        ReplicatorXMLStore owner;
        XMLStore xmlstore;
        Reference vref;

        public LoadThread(ReplicatorXMLStore owner, XMLStore xmlstore,
                                                  Reference vref) {
            this.owner = owner;
            this.xmlstore = xmlstore;
            this.vref = vref;
        }

        public void run() {
            Node node;
            try {
                node = xmlstore.load(vref);
            } catch (IOException e) {
                node = null; /* FIXME */
            } catch (UnknownReferenceException e) {
                node = null; /* FIXME */
            }
            System.out.println("Okay, finally loaded" + node == null ? ", but it is null" : "");
            owner.setLoadResult(node);
        }
    }
}
