package org.planx.xmlstore.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.planx.util.Converter;

/**
 * @author Thomas Ambus
 */
public class FileSystemIdentifier {
    private static final int LENGTH = 5;
    private int hash;
    private byte[] b;

    public FileSystemIdentifier() {
        b = new byte[LENGTH];
        for (int i=0; i<LENGTH; i++) {
            b[i] = (byte) (Math.random()*256);
        }
    }

    private FileSystemIdentifier(byte[] b) {
        this.b = b;
    }

    public boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof FileSystemIdentifier)) return false;
        return Arrays.equals(b, ((FileSystemIdentifier) o).b);
    }

    public int hashCode() {
        if (hash == 0) hash = Arrays.hashCode(b);
        return hash;
    }

    byte[] internal() {
        return b;
    }

    public String toString() {
        return Converter.toHex(b);
    }

    public static Streamer<FileSystemIdentifier> getStreamer() {
        return new Streamer<FileSystemIdentifier>() {
            public void toStream(DataOutput out, FileSystemIdentifier fsi)
                                            throws IOException {
                out.write(fsi.b);
            }

            public FileSystemIdentifier fromStream(DataInput in)
                                            throws IOException {
                byte[] b = new byte[LENGTH];
                in.readFully(b);
                return new FileSystemIdentifier(b);
            }
        };
    }
}
