package org.planx.xmlstore.docnodes;

import org.planx.xmlstore.Attribute;

/**
 * An Attribute returned by {@link DocNode}.
 * Note that this class also provides the ability to get
 * the owner of the attribute.
 *
 * @author Thomas Ambus
 */
public class DocAttribute implements Attribute, Comparable<Attribute> {
    private Attribute attr;
    private DocNode owner;

    DocAttribute(Attribute attr, DocNode owner) {
        this.attr = attr;
        this.owner = owner;
    }

    /**
     * Returns the DocNode to which this attribute
     * belongs.
     */
    public DocNode getOwner() {
        return owner;
    }

    public String getValue() {
        return attr.getValue();
    }

    public String getName() {
        return attr.getName();
    }

    public boolean equals(Object o) {
        return attr.equals(o);
    }

    public int hashCode() {
        return attr.hashCode();
    }

    public int compareTo(Attribute o) {
        return attr.compareTo(o);
    }

    /**
     * Returns the value of this attribute
     */
    public String toString() {
        return getValue();
    }

    public char charAt(int index) {
        return attr.charAt(index);
    }

    public int length() {
        return attr.length();
    }

    public CharSequence subSequence(int start, int end) {
        return attr.subSequence(start, end);
    }
}
