package org.planx.msd.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.planx.msd.*;
import org.planx.util.Association;
import org.planx.util.Pair;

/**
 * A <code>CacheDiscriminator</code> is used to break long chains of
 * <code>Extractor</code>s in complex discriminators. This is done
 * by simply extracting the values and caching them.
 *
 * @author Thomas Ambus
 */
public class CacheDiscriminator<T> extends AbstractDiscriminator<T> {
    private Discriminator<T> disc;
    private Extractor<Pair<T,Object>,T,Object> ext =
        Discriminators.pairExtractor();

    public CacheDiscriminator(Discriminator<T> d) {
        disc = d;
    }

    public <U,S> Collection<List<S>> discriminate(List<? extends U> values,
                                              Extractor<U,? extends T,S> e) {
        int size = values.size();
        Pair[] ps = new Association[size];

        int i=0;
        for (U elm : values) {
            ps[i] = new Association(e.getLabel(elm), e.getValue(elm));
            i++;
        }
        return disc.discriminate(Arrays.asList(ps), (Extractor) ext);
    }
}
