package org.planx.msd.number;

import java.util.AbstractList;
import java.util.List;
import org.planx.msd.*;

/**
 * A <code>Discriminator</code> capable of discriminating a multiset of
 * <code>Double</code> objects.
 *
 * @author Thomas Ambus
 */
public class DoubleDiscriminator extends NumberDiscriminator<Double> {
    public DoubleDiscriminator(Memory memory) {super(memory);}

    protected int bitsize() {return 64;}

    protected <U> ChunkExtractor<U> chunkExtractor(Extractor<U,
                                ? extends Double,?> e) {
        return new ChunkExtractor<U>(e) {
            public int getLabel(U elm) {
                Double value = e.getLabel(elm);
                return (int) ((Double.doubleToLongBits(value) >> offset)
                        & CHUNK_MASK);
            }
        };
    }
}
