package org.planx.msd.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.planx.msd.*;
import org.planx.msd.character.*;
import org.planx.msd.util.*;

/**
 * A <code>Discriminator</code> capable of discriminating a multiset of
 * <code>Object</code>s according to their <code>Class</code>. The
 * discrimination is done using the <code>String</code>
 * name of the <code>Object</code>'s class, that is, on
 * <code>Object.getClass().getName()</code>.
 * <p>
 * <b>Note that this implementation is not synchronized.</b> If
 * multiple threads access an instance of this class concurrently,
 * it must be synchronized externally.
 *
 * @author Thomas Ambus
 */
public class ClassDiscriminator<T> extends AbstractDiscriminator<T> {
    private final Discriminator<String> strDisc;

    /**
     * Constructs a new <code>ClassDiscriminator</code> reusing the memory
     * allocated in the specified <code>Memory</code>.
     */
    public ClassDiscriminator(Memory memory) {
        strDisc = new CharSequenceDiscriminator<String>(memory);
    }

    public <U,S> Collection<List<S>> discriminate(List<? extends U> values,
                                        final Extractor<U,? extends T,S> e) {
        Extractor<U,String,S> classExtractor =
            new Extractor<U,String,S>() {
                public String getLabel(U element) {
                    return e.getLabel(element).getClass().getName();
                }

                public S getValue(U element) {
                    return e.getValue(element);
                }
            };
        return strDisc.discriminate(values, classExtractor);
    }
}
