package org.planx.msd.graph;

import java.util.*;
import org.planx.msd.*;
import org.planx.msd.character.*;
import org.planx.msd.list.*;
import org.planx.msd.lang.*;
import org.planx.msd.util.*;
import org.planx.util.Association;
import org.planx.util.Pair;

/**
 * @author Thomas Ambus
 */
public class TemplateNode<N,L> extends Association<N,List<TemplateNode<N,L>.Pointer>>
                               implements EquivalenceClassDiscriminable {
    protected Discriminator<N> nameDisc = new MatchAllDiscriminator<N>();
    protected Discriminator<L> labelDisc = new MatchAllDiscriminator<L>();
    protected EquivalenceClass eqCls = new EquivalenceClass();
    protected Object visitToken = null;
    protected int height = -1;

    public TemplateNode(N name) {
        this(name, null);
    }

    public TemplateNode(N name, List<TemplateNode<N,L>.Pointer> pointers) {
        super(name, pointers);
        if (pointers == null) second = Collections.emptyList();
    }

    public TemplateNode(N name, List<TemplateNode<N,L>.Pointer> pointers,
                   Discriminator<N> nameDisc, Discriminator<L> labelDisc) {
        this(name, pointers);
        this.nameDisc = nameDisc;
        this.labelDisc = labelDisc;
    }

    public TemplateNode<N,L>.Pointer createPointer(L label,
                                    TemplateNode<N,L> node) {
        return new TemplateNode.Pointer(label, node);
    }

    public void compact() {
        Navigator<TemplateNode<N,L>> nav = getNavigator();
        Discriminator<TemplateNode<N,L>> d = getDiscriminator();
        Compactor<TemplateNode<N,L>> compactor =
            new Compactor<TemplateNode<N,L>>(nav, d);
        compactor.share(this);
    }

    public N getName() {
        return getFirst();
    }

    public void setName(N name) {
        first = name;
    }

    public List<TemplateNode<N,L>.Pointer> getPointers() {
        return getSecond();
    }

    public void setPointers(List<TemplateNode<N,L>.Pointer> pointers) {
        second = pointers;
    }

    public EquivalenceClass getEquivalenceClass() {
        return eqCls;
    }

    public void setEquivalenceClass(EquivalenceClass eqCls) {
        this.eqCls = eqCls;
    }

    public class Pointer extends Association<L,TemplateNode<N,L>>
                             implements Pair<L,TemplateNode<N,L>> {
        public Pointer(L label, TemplateNode<N,L> node) {
            super(label, node);
        }

        public L getLabel() {
            return getFirst();
        }

        public void setLabel(L label) {
            first = label;
        }

        public TemplateNode<N,L> getNode() {
            return getSecond();
        }

        public void setNode(TemplateNode<N,L> node) {
            second = node;
        }
    }

    public Discriminator<TemplateNode<N,L>> getDiscriminator() {
        DiscriminatorFactory factory = DiscriminatorFactory.instance();
        Discriminator<TemplateNode<N,L>> childDisc =
            new EquivalenceClassDiscriminator<TemplateNode<N,L>>();
        Discriminator<TemplateNode<N,L>.Pointer> ptrDisc =
            //(Discriminator<TemplateNode<N,L>.Pointer>)
            (Discriminator)
            new PairDiscriminator<L,TemplateNode<N,L>>(labelDisc,childDisc);
        Discriminator<List<TemplateNode<N,L>.Pointer>> ptrSetDisc =
            factory.getSetDiscriminator(ptrDisc);
        Discriminator<TemplateNode<N,L>> nodeDisc =
            //(Discriminator<TemplateNode<N,L>>)
            (Discriminator)
            new PairDiscriminator<N,List<TemplateNode<N,L>.Pointer>>
                (nameDisc,ptrSetDisc);
        return nodeDisc;
    }

    /**
     * Returns a <code>Navigator</code> for <code>TemplateNode</code> objects.
     */
    public Navigator<TemplateNode<N,L>> getNavigator() {
        return new TemplateNavigator();
    }

    protected class TemplateNavigator implements Navigator<TemplateNode<N,L>> {
        public TemplateNode<N,L> getChild(TemplateNode<N,L> node, int index) {
            return node.getPointers().get(index).getNode();
        }

        public void setChild(TemplateNode<N,L> node, int index,
                                        TemplateNode<N,L> child) {
            node.getPointers().get(index).setNode(child);
        }

        public int childCount(TemplateNode<N,L> node) {
            return node.getPointers().size();
        }

        public Object getVisitToken(TemplateNode<N,L> node) {
            return node.visitToken;
        }

        public void setVisitToken(TemplateNode<N,L> node, Object token) {
            node.visitToken = token;
        }

        public int getHeight(TemplateNode<N,L> node) {
            return node.height;
        }

        public void setHeight(TemplateNode<N,L> node, int height) {
            node.height = height;
        }

        public boolean isOutside(TemplateNode<N,L> node) {
            return false;
        }

        public TemplateNode<N,L> chooseCanonical(
                        List<Compactor<TemplateNode<N,L>>.Edge> eqCls) {
            return eqCls.get(0).node;
        }
    }
}
