/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractSuppressionAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.xml.suppression.SuppressionRule;

public class VulnerabilitySuppressionAnalyzer
extends AbstractSuppressionAnalyzer {
    private static final String ANALYZER_NAME = "Vulnerability Suppression Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.POST_FINDING_ANALYSIS;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.vulnerabilitysuppression.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.getRules() == null || this.getRules().size() <= 0) {
            return;
        }
        for (SuppressionRule rule : this.getRules()) {
            rule.process(dependency);
        }
    }
}

