/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.cache.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.ops4j.io.StreamUtils;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.cache.internal.Configuration;
import org.ops4j.pax.url.cache.internal.Parser;

public class Connection
extends URLConnection {
    private Parser m_parser;
    private final Configuration m_configuration;
    private final String m_cacheName;
    private static final String META_URL = "url";
    private static final String META_CACHED_ON = "cachedOn";
    private static final String EXT_META = ".meta";
    private static final String EXT_DATA = ".data";

    protected Connection(URL url, Configuration configuration) throws IOException {
        super(url);
        NullArgumentException.validateNotNull(url, "URL");
        NullArgumentException.validateNotNull(configuration, "Configuration");
        this.m_parser = new Parser(url.getPath());
        this.m_configuration = configuration;
        this.m_cacheName = Connection.generateCacheName(this.m_parser.getUrl());
    }

    private static String generateCacheName(URL url) throws IOException {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Cannot generate caching name (MD5 not supported)");
        }
        String encoded = new BigInteger(1, md5.digest(url.toExternalForm().getBytes())).toString(16);
        if (encoded.length() == 31) {
            encoded = "0" + encoded;
        }
        return encoded;
    }

    public void connect() {
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        File workingDir = this.m_configuration.getWorkingDirectory();
        File cacheMetaFile = new File(workingDir, this.m_cacheName + EXT_META);
        File cacheDateFile = new File(workingDir, this.m_cacheName + EXT_DATA);
        Properties cacheMeta = new Properties();
        try {
            cacheMeta.load(new FileInputStream(cacheMetaFile));
        }
        catch (FileNotFoundException ignore) {
            // empty catch block
        }
        String cacheUrl = cacheMeta.getProperty(META_URL);
        if (cacheUrl == null) {
            cacheMeta.setProperty(META_URL, this.url.getPath());
        }
        cacheMeta.store(new FileOutputStream(cacheMetaFile), null);
        String cacheTime = cacheMeta.getProperty(META_CACHED_ON);
        if (cacheTime == null || !cacheDateFile.exists()) {
            StreamUtils.copyStream(this.m_parser.getUrl().openStream(), new BufferedOutputStream(new FileOutputStream(cacheDateFile)), true);
            cacheMeta.setProperty(META_CACHED_ON, String.valueOf(System.currentTimeMillis()));
            cacheMeta.store(new FileOutputStream(cacheMetaFile), null);
        }
        return new BufferedInputStream(new FileInputStream(cacheDateFile));
    }
}

