/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.assembly.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.ops4j.io.ListerUtils;
import org.ops4j.pax.url.assembly.internal.Source;

public class PathEncodedSource
implements Source {
    private final String m_path;
    private final Pattern[] m_includes;
    private final Pattern[] m_excludes;

    public PathEncodedSource(String path) {
        if (path.contains("!/")) {
            String[] filters;
            int startOfFilter = path.lastIndexOf("!/");
            this.m_path = path.substring(0, startOfFilter);
            ArrayList<Pattern> includes = new ArrayList<Pattern>();
            ArrayList<Pattern> excludes = new ArrayList<Pattern>();
            for (String filter : filters = path.substring(startOfFilter + 2).split("&")) {
                if (filter.startsWith("!")) {
                    excludes.add(ListerUtils.parseFilter(filter.substring(1)));
                    continue;
                }
                includes.add(ListerUtils.parseFilter(filter));
            }
            this.m_includes = includes.toArray(new Pattern[includes.size()]);
            this.m_excludes = excludes.toArray(new Pattern[excludes.size()]);
        } else {
            this.m_path = path;
            this.m_includes = new Pattern[]{ListerUtils.parseFilter("**")};
            this.m_excludes = new Pattern[0];
        }
    }

    public String path() {
        return this.m_path;
    }

    public Pattern[] includes() {
        return this.m_includes;
    }

    public Pattern[] excludes() {
        return this.m_excludes;
    }

    public String toString() {
        return String.format("%s includes(%s) excludes(%s)", this.m_path, Arrays.deepToString(this.m_includes), Arrays.deepToString(this.m_excludes));
    }
}

