/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.osgi;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.framework.FilterImpl;
import org.ops4j.pax.runner.Context;
import org.ops4j.pax.runner.osgi.RunnerBundle;
import org.ops4j.pax.runner.osgi.UnsupportedBundle;
import org.ops4j.pax.runner.osgi.UnsupportedBundleContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class RunnerBundleContext
extends UnsupportedBundleContext {
    private final Context m_context;
    private final Bundle m_bundle = new RunnerBundle();

    public RunnerBundleContext(Context context) {
        this.m_context = context;
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return new FilterImpl(filter);
    }

    public void addServiceListener(ServiceListener serviceListener, String filter) throws InvalidSyntaxException {
        Filter osgiFilter = null;
        if (filter != null) {
            osgiFilter = this.createFilter(filter);
        }
        this.m_context.getEventDispatcher().addListener(this.m_bundle, ServiceListener.class, serviceListener, osgiFilter);
    }

    public ServiceReference getServiceReference(String clazz) {
        try {
            ServiceReference[] references = this.getServiceReferences(clazz, null);
            if (references != null && references.length > 0) {
                return references[0];
            }
            return null;
        }
        catch (InvalidSyntaxException ignore) {
            return null;
        }
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        List references;
        Filter osgiFilter = null;
        if (filter != null) {
            osgiFilter = this.createFilter(filter);
        }
        if ((references = this.m_context.getServiceRegistry().getServiceReferences(clazz, osgiFilter)) != null) {
            return references.toArray(new ServiceReference[references.size()]);
        }
        return null;
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        return this.m_context.getServiceRegistry().registerService(new UnsupportedBundle(), new String[]{clazz}, service, properties);
    }

    public Object getService(ServiceReference serviceReference) {
        return this.m_context.getServiceRegistry().getService(this.m_bundle, serviceReference);
    }

    public String getProperty(String key) {
        return this.m_context.getOptionResolver().get(key);
    }

    public Bundle installBundle(String location) throws BundleException {
        URL url;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            throw new BundleException("Invalid location [" + location + "]");
        }
        RunnerBundle bundle = new RunnerBundle(url);
        this.m_context.addBundle(bundle);
        return bundle;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public void addBundleListener(BundleListener bundleListener) {
    }

    public Bundle[] getBundles() {
        return new Bundle[0];
    }
}

