/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;
import org.openscience.cdk.tools.manipulator.ChemSequenceManipulator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.cdk.tools.manipulator.ReactionSetManipulator;

public abstract class IDCreator {
    private static int reactionCount = 0;
    private static int atomCount = 0;
    private static int bondCount = 0;
    private static int atomContainerCount = 0;
    private static int atomContainerSetCount = 0;
    private static int reactionSetCount = 0;
    private static int chemModelCount = 0;
    private static int chemSequenceCount = 0;
    private static int chemFileCount = 0;
    private static final String REACTION_PREFIX = "r";
    private static final String ATOM_PREFIX = "a";
    private static final String BOND_PREFIX = "b";
    private static final String ATOMCONTAINER_PREFIX = "m";
    private static final String ATOMCONTAINERSET_PREFIX = "molSet";
    private static final String REACTIONSET_PREFIX = "rset";
    private static final String CHEMMODEL_PREFIX = "model";
    private static final String CHEMSEQUENCE_PREFIX = "seq";
    private static final String CHEMFILE_PREFIX = "file";
    public static final int SET_UNIQUE_POLICY = 0;
    public static final int OBJECT_UNIQUE_POLICY = 1;
    private static int policy = 0;

    public static void setIDPolicy(int policy) {
        IDCreator.policy = policy;
    }

    public static void createIDs(IChemObject chemObject) {
        if (chemObject == null) {
            return;
        }
        IDCreator.resetCounters();
        if (chemObject instanceof IAtomContainer) {
            IDCreator.createIDsForAtomContainer((IAtomContainer)chemObject, null);
        } else if (chemObject instanceof IAtomContainerSet) {
            IDCreator.createIDsForAtomContainerSet((IAtomContainerSet)chemObject, null);
        } else if (chemObject instanceof IReaction) {
            IDCreator.createIDsForReaction((IReaction)chemObject, null);
        } else if (chemObject instanceof IReactionSet) {
            IDCreator.createIDsForReactionSet((IReactionSet)chemObject, null);
        } else if (chemObject instanceof IChemFile) {
            IDCreator.createIDsForChemFile((IChemFile)chemObject, null);
        } else if (chemObject instanceof IChemSequence) {
            IDCreator.createIDsForChemSequence((IChemSequence)chemObject, null);
        } else if (chemObject instanceof IChemModel) {
            IDCreator.createIDsForChemModel((IChemModel)chemObject, null);
        }
    }

    private static void resetCounters() {
        atomCount = 0;
        bondCount = 0;
        atomContainerCount = 0;
        atomContainerSetCount = 0;
        reactionCount = 0;
        reactionSetCount = 0;
        chemModelCount = 0;
        chemSequenceCount = 0;
        chemFileCount = 0;
    }

    private static int setID(String prefix, int identifier, IChemObject object, List<String> tabuList) {
        ++identifier;
        while (tabuList.contains(prefix + identifier)) {
            ++identifier;
        }
        object.setID(prefix + identifier);
        tabuList.add(prefix + identifier);
        return identifier;
    }

    private static void createIDsForAtomContainer(IAtomContainer container, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = AtomContainerManipulator.getAllIDs(container);
        }
        if (null == container.getID()) {
            atomContainerCount = IDCreator.setID(ATOMCONTAINER_PREFIX, atomContainerCount, (IChemObject)container, tabuList);
        }
        List<String> internalTabuList = AtomContainerManipulator.getAllIDs(container);
        if (policy == 1) {
            atomCount = 0;
            bondCount = 0;
        } else {
            internalTabuList = tabuList;
        }
        for (IAtom atom : container.atoms()) {
            if (null != atom.getID()) continue;
            atomCount = IDCreator.setID(ATOM_PREFIX, atomCount, (IChemObject)atom, internalTabuList);
        }
        for (IBond bond : container.bonds()) {
            if (null != bond.getID()) continue;
            bondCount = IDCreator.setID(BOND_PREFIX, bondCount, (IChemObject)bond, internalTabuList);
        }
    }

    private static void createIDsForAtomContainerSet(IAtomContainerSet containerSet, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = AtomContainerSetManipulator.getAllIDs(containerSet);
        }
        if (null == containerSet.getID()) {
            atomContainerSetCount = IDCreator.setID(ATOMCONTAINERSET_PREFIX, atomContainerSetCount, (IChemObject)containerSet, tabuList);
        }
        if (policy == 1) {
            atomCount = 0;
            bondCount = 0;
        }
        Iterator acs = containerSet.atomContainers().iterator();
        while (acs.hasNext()) {
            IDCreator.createIDsForAtomContainer((IAtomContainer)acs.next(), tabuList);
        }
    }

    private static void createIDsForReaction(IReaction reaction, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = ReactionManipulator.getAllIDs(reaction);
        }
        if (null == reaction.getID()) {
            reactionCount = IDCreator.setID(REACTION_PREFIX, reactionCount, (IChemObject)reaction, tabuList);
        }
        if (policy == 1) {
            atomCount = 0;
            bondCount = 0;
        }
        for (IAtomContainer reactant : reaction.getReactants().atomContainers()) {
            IDCreator.createIDsForAtomContainer(reactant, tabuList);
        }
        for (IAtomContainer product : reaction.getReactants().atomContainers()) {
            IDCreator.createIDsForAtomContainer(product, tabuList);
        }
        Iterator agents = reaction.getAgents().atomContainers().iterator();
        while (agents.hasNext()) {
            IDCreator.createIDsForAtomContainer((IAtomContainer)agents.next(), tabuList);
        }
    }

    private static void createIDsForReactionSet(IReactionSet reactionSet, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = ReactionSetManipulator.getAllIDs(reactionSet);
        }
        if (null == reactionSet.getID()) {
            reactionSetCount = IDCreator.setID(REACTIONSET_PREFIX, reactionSetCount, (IChemObject)reactionSet, tabuList);
        }
        Iterator reaction = reactionSet.reactions().iterator();
        while (reaction.hasNext()) {
            IDCreator.createIDsForReaction((IReaction)reaction.next(), tabuList);
        }
    }

    private static void createIDsForChemFile(IChemFile file, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = ChemFileManipulator.getAllIDs(file);
        }
        if (null == file.getID()) {
            chemFileCount = IDCreator.setID(CHEMFILE_PREFIX, chemFileCount, (IChemObject)file, tabuList);
        }
        if (policy == 1) {
            chemSequenceCount = 0;
        }
        for (IChemSequence chemSequence : file.chemSequences()) {
            IDCreator.createIDsForChemSequence(chemSequence, tabuList);
        }
    }

    private static void createIDsForChemSequence(IChemSequence sequence, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = ChemSequenceManipulator.getAllIDs(sequence);
        }
        if (null == sequence.getID()) {
            chemSequenceCount = IDCreator.setID(CHEMSEQUENCE_PREFIX, chemSequenceCount, (IChemObject)sequence, tabuList);
        }
        if (policy == 1) {
            chemSequenceCount = 0;
        }
        for (IChemModel chemModel : sequence.chemModels()) {
            IDCreator.createIDsForChemModel(chemModel, tabuList);
        }
    }

    private static void createIDsForChemModel(IChemModel model, List<String> tabuList) {
        IReactionSet reactionSet;
        IAtomContainerSet moleculeSet;
        ICrystal crystal;
        if (tabuList == null) {
            tabuList = ChemModelManipulator.getAllIDs(model);
        }
        if (null == model.getID()) {
            chemModelCount = IDCreator.setID(CHEMMODEL_PREFIX, chemModelCount, (IChemObject)model, tabuList);
        }
        if ((crystal = model.getCrystal()) != null) {
            if (policy == 1) {
                atomCount = 0;
                bondCount = 0;
            }
            IDCreator.createIDsForAtomContainer((IAtomContainer)crystal, tabuList);
        }
        if ((moleculeSet = model.getMoleculeSet()) != null) {
            if (policy == 1) {
                atomContainerSetCount = 0;
                atomContainerCount = 0;
            }
            IDCreator.createIDsForAtomContainerSet(moleculeSet, tabuList);
        }
        if ((reactionSet = model.getReactionSet()) != null) {
            if (policy == 1) {
                reactionSetCount = 0;
                reactionCount = 0;
            }
            IDCreator.createIDsForReactionSet(reactionSet, tabuList);
        }
    }
}

