/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.alignment;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class KabschAlignment {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(KabschAlignment.class);
    private double[][] U;
    private double rmsd = -1.0;
    private Point3d[] p1;
    private Point3d[] p2;
    private Point3d[] rp;
    private double[] wts;
    private int npoint;
    private Point3d cm1;
    private Point3d cm2;
    private double[] atwt1;
    private double[] atwt2;

    private Point3d[] getPoint3dArray(IAtom[] a) {
        Point3d[] p = new Point3d[a.length];
        for (int i = 0; i < a.length; ++i) {
            p[i] = new Point3d(a[i].getPoint3d());
        }
        return p;
    }

    private Point3d[] getPoint3dArray(IAtomContainer ac) {
        Point3d[] p = new Point3d[ac.getAtomCount()];
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            p[i] = new Point3d(ac.getAtom(i).getPoint3d());
        }
        return p;
    }

    private double[] getAtomicMasses(IAtom[] a) {
        double[] am = new double[a.length];
        Isotopes factory = null;
        try {
            factory = Isotopes.getInstance();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while instantiating the isotope factory: ", new Object[]{e.getMessage()});
            this.logger.debug((Object)e);
        }
        assert (factory != null);
        for (int i = 0; i < a.length; ++i) {
            am[i] = factory.getMajorIsotope(a[i].getSymbol()).getExactMass();
        }
        return am;
    }

    private double[] getAtomicMasses(IAtomContainer ac) {
        double[] am = new double[ac.getAtomCount()];
        Isotopes factory = null;
        try {
            factory = Isotopes.getInstance();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while instantiating the isotope factory: ", new Object[]{e.getMessage()});
            this.logger.debug((Object)e);
        }
        assert (factory != null);
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            am[i] = factory.getMajorIsotope(ac.getAtom(i).getSymbol()).getExactMass();
        }
        return am;
    }

    private Point3d getCenterOfMass(Point3d[] p, double[] atwt) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double totalmass = 0.0;
        for (int i = 0; i < p.length; ++i) {
            x += atwt[i] * p[i].x;
            y += atwt[i] * p[i].y;
            z += atwt[i] * p[i].z;
            totalmass += atwt[i];
        }
        return new Point3d(x / totalmass, y / totalmass, z / totalmass);
    }

    public KabschAlignment(IAtom[] al1, IAtom[] al2) throws CDKException {
        if (al1.length != al2.length) {
            throw new CDKException("The Atom[]'s being aligned must have the same numebr of atoms");
        }
        this.npoint = al1.length;
        this.p1 = this.getPoint3dArray(al1);
        this.p2 = this.getPoint3dArray(al2);
        this.wts = new double[this.npoint];
        this.atwt1 = this.getAtomicMasses(al1);
        this.atwt2 = this.getAtomicMasses(al2);
        for (int i = 0; i < this.npoint; ++i) {
            this.wts[i] = 1.0;
        }
    }

    public KabschAlignment(IAtom[] al1, IAtom[] al2, double[] wts) throws CDKException {
        if (al1.length != al2.length) {
            throw new CDKException("The Atom[]'s being aligned must have the same number of atoms");
        }
        if (al1.length != wts.length) {
            throw new CDKException("Number of weights must equal number of atoms");
        }
        this.npoint = al1.length;
        this.p1 = this.getPoint3dArray(al1);
        this.p2 = this.getPoint3dArray(al2);
        this.wts = new double[this.npoint];
        System.arraycopy(wts, 0, this.wts, 0, this.npoint);
        this.atwt1 = this.getAtomicMasses(al1);
        this.atwt2 = this.getAtomicMasses(al2);
    }

    public KabschAlignment(IAtomContainer ac1, IAtomContainer ac2) throws CDKException {
        if (ac1.getAtomCount() != ac2.getAtomCount()) {
            throw new CDKException("The AtomContainer's being aligned must have the same number of atoms");
        }
        this.npoint = ac1.getAtomCount();
        this.p1 = this.getPoint3dArray(ac1);
        this.p2 = this.getPoint3dArray(ac2);
        this.wts = new double[this.npoint];
        for (int i = 0; i < this.npoint; ++i) {
            this.wts[i] = 1.0;
        }
        this.atwt1 = this.getAtomicMasses(ac1);
        this.atwt2 = this.getAtomicMasses(ac2);
    }

    public KabschAlignment(IAtomContainer ac1, IAtomContainer ac2, double[] wts) throws CDKException {
        if (ac1.getAtomCount() != ac2.getAtomCount()) {
            throw new CDKException("The AtomContainer's being aligned must have the same number of atoms");
        }
        if (ac1.getAtomCount() != wts.length) {
            throw new CDKException("Number of weights must equal number of atoms");
        }
        this.npoint = ac1.getAtomCount();
        this.p1 = this.getPoint3dArray(ac1);
        this.p2 = this.getPoint3dArray(ac2);
        this.wts = new double[this.npoint];
        System.arraycopy(wts, 0, this.wts, 0, this.npoint);
        this.atwt1 = this.getAtomicMasses(ac1);
        this.atwt2 = this.getAtomicMasses(ac2);
    }

    public void align() {
        int j;
        int i;
        int i2;
        int i3;
        this.cm1 = new Point3d();
        this.cm2 = new Point3d();
        this.cm1 = this.getCenterOfMass(this.p1, this.atwt1);
        this.cm2 = this.getCenterOfMass(this.p2, this.atwt2);
        for (int i4 = 0; i4 < this.npoint; ++i4) {
            this.p1[i4].x -= this.cm1.x;
            this.p1[i4].y -= this.cm1.y;
            this.p1[i4].z -= this.cm1.z;
            this.p2[i4].x -= this.cm2.x;
            this.p2[i4].y -= this.cm2.y;
            this.p2[i4].z -= this.cm2.z;
        }
        double[][] tR = new double[3][3];
        for (i3 = 0; i3 < this.npoint; ++i3) {
            this.wts[i3] = 1.0;
        }
        for (i3 = 0; i3 < this.npoint; ++i3) {
            double[] dArray = tR[0];
            dArray[0] = dArray[0] + this.p1[i3].x * this.p2[i3].x * this.wts[i3];
            double[] dArray2 = tR[0];
            dArray2[1] = dArray2[1] + this.p1[i3].x * this.p2[i3].y * this.wts[i3];
            double[] dArray3 = tR[0];
            dArray3[2] = dArray3[2] + this.p1[i3].x * this.p2[i3].z * this.wts[i3];
            double[] dArray4 = tR[1];
            dArray4[0] = dArray4[0] + this.p1[i3].y * this.p2[i3].x * this.wts[i3];
            double[] dArray5 = tR[1];
            dArray5[1] = dArray5[1] + this.p1[i3].y * this.p2[i3].y * this.wts[i3];
            double[] dArray6 = tR[1];
            dArray6[2] = dArray6[2] + this.p1[i3].y * this.p2[i3].z * this.wts[i3];
            double[] dArray7 = tR[2];
            dArray7[0] = dArray7[0] + this.p1[i3].z * this.p2[i3].x * this.wts[i3];
            double[] dArray8 = tR[2];
            dArray8[1] = dArray8[1] + this.p1[i3].z * this.p2[i3].y * this.wts[i3];
            double[] dArray9 = tR[2];
            dArray9[2] = dArray9[2] + this.p1[i3].z * this.p2[i3].z * this.wts[i3];
        }
        double[][] R = new double[3][3];
        Matrix tmp = new Matrix(tR);
        R = tmp.transpose().getArray();
        double[][] RtR = new double[3][3];
        Matrix jamaR = new Matrix(R);
        tmp = tmp.times(jamaR);
        RtR = tmp.getArray();
        Matrix jamaRtR = new Matrix(RtR);
        EigenvalueDecomposition ed = jamaRtR.eig();
        double[] mu = ed.getRealEigenvalues();
        double[][] a = ed.getV().getArray();
        double tmp2 = mu[2];
        mu[2] = mu[0];
        mu[0] = tmp2;
        for (int i5 = 0; i5 < 3; ++i5) {
            tmp2 = a[i5][2];
            a[i5][2] = a[i5][0];
            a[i5][0] = tmp2;
        }
        a[0][2] = a[1][0] * a[2][1] - a[1][1] * a[2][0];
        a[1][2] = a[0][1] * a[2][0] - a[0][0] * a[2][1];
        a[2][2] = a[0][0] * a[1][1] - a[0][1] * a[1][0];
        double[][] b = new double[3][3];
        for (int i6 = 0; i6 < 3; ++i6) {
            for (int j2 = 0; j2 < 3; ++j2) {
                for (int k = 0; k < 3; ++k) {
                    double[] dArray = b[i6];
                    int n = j2;
                    dArray[n] = dArray[n] + R[i6][k] * a[k][j2];
                }
                b[i6][j2] = b[i6][j2] / Math.sqrt(mu[j2]);
            }
        }
        double norm1 = 0.0;
        double norm2 = 0.0;
        for (i2 = 0; i2 < 3; ++i2) {
            norm1 += b[i2][0] * b[i2][0];
            norm2 += b[i2][1] * b[i2][1];
        }
        norm1 = Math.sqrt(norm1);
        norm2 = Math.sqrt(norm2);
        for (i2 = 0; i2 < 3; ++i2) {
            b[i2][0] = b[i2][0] / norm1;
            b[i2][1] = b[i2][1] / norm2;
        }
        b[0][2] = b[1][0] * b[2][1] - b[1][1] * b[2][0];
        b[1][2] = b[0][1] * b[2][0] - b[0][0] * b[2][1];
        b[2][2] = b[0][0] * b[1][1] - b[0][1] * b[1][0];
        double[][] tU = new double[3][3];
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    double[] dArray = tU[i];
                    int n = j;
                    dArray[n] = dArray[n] + b[i][k] * a[j][k];
                }
            }
        }
        this.U = new double[3][3];
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.U[i][j] = tU[j][i];
            }
        }
        this.rp = new Point3d[this.npoint];
        for (i = 0; i < this.npoint; ++i) {
            this.rp[i] = new Point3d(this.U[0][0] * this.p2[i].x + this.U[0][1] * this.p2[i].y + this.U[0][2] * this.p2[i].z, this.U[1][0] * this.p2[i].x + this.U[1][1] * this.p2[i].y + this.U[1][2] * this.p2[i].z, this.U[2][0] * this.p2[i].x + this.U[2][1] * this.p2[i].y + this.U[2][2] * this.p2[i].z);
        }
        double rms = 0.0;
        for (int i7 = 0; i7 < this.npoint; ++i7) {
            rms += (this.p1[i7].x - this.rp[i7].x) * (this.p1[i7].x - this.rp[i7].x) + (this.p1[i7].y - this.rp[i7].y) * (this.p1[i7].y - this.rp[i7].y) + (this.p1[i7].z - this.rp[i7].z) * (this.p1[i7].z - this.rp[i7].z);
        }
        this.rmsd = Math.sqrt(rms / (double)this.npoint);
    }

    public double getRMSD() {
        return this.rmsd;
    }

    public double[][] getRotationMatrix() {
        return this.U;
    }

    public Point3d getCenterOfMass() {
        return this.cm1;
    }

    public void rotateAtomContainer(IAtomContainer ac) {
        Point3d[] p = this.getPoint3dArray(ac);
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            p[i].x -= this.cm2.x;
            p[i].y -= this.cm2.y;
            p[i].z -= this.cm2.z;
            ac.getAtom(i).setPoint3d(new Point3d(this.U[0][0] * p[i].x + this.U[0][1] * p[i].y + this.U[0][2] * p[i].z, this.U[1][0] * p[i].x + this.U[1][1] * p[i].y + this.U[1][2] * p[i].z, this.U[2][0] * p[i].x + this.U[2][1] * p[i].y + this.U[2][2] * p[i].z));
        }
    }
}

