/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.templates;

import javax.vecmath.Point2d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class TestMoleculeFactory {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(TestMoleculeFactory.class);

    private static IAtomContainer newAtomContainer() {
        return DefaultChemObjectBuilder.getInstance().newAtomContainer();
    }

    public static IAtomContainer makeAlphaPinene() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        mol.addBond(3, 7, IBond.Order.SINGLE);
        mol.addBond(5, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(7, 9, IBond.Order.SINGLE);
        TestMoleculeFactory.configureAtoms(mol);
        return mol;
    }

    public static IAtomContainer makeAlkane(int chainLength) {
        IAtomContainer currentChain = TestMoleculeFactory.newAtomContainer();
        currentChain.addAtom((IAtom)new Atom("C"));
        for (int atomCount = 1; atomCount < chainLength; ++atomCount) {
            currentChain.addAtom((IAtom)new Atom("C"));
            currentChain.addBond(atomCount, atomCount - 1, IBond.Order.SINGLE);
        }
        return currentChain;
    }

    public static IAtomContainer makeEthylCyclohexane() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeCyclohexene() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeCyclohexane() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeCyclopentane() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeCyclobutane() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeCyclobutadiene() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.DOUBLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePropylCycloPropane() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 0, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeBiphenyl() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.DOUBLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 10, IBond.Order.DOUBLE);
        mol.addBond(10, 11, IBond.Order.SINGLE);
        mol.addBond(11, 6, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePhenylEthylBenzene() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 10, IBond.Order.DOUBLE);
        mol.addBond(10, 11, IBond.Order.SINGLE);
        mol.addBond(11, 12, IBond.Order.DOUBLE);
        mol.addBond(12, 13, IBond.Order.SINGLE);
        mol.addBond(13, 8, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePhenylAmine() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer make4x3CondensedRings() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 0, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(1, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 2, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 3, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeSpiroRings() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 0, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 6, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeBicycloRings() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(6, 0, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 3, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeFusedRings() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 4, IBond.Order.SINGLE);
        mol.addBond(8, 0, IBond.Order.SINGLE);
        mol.addBond(9, 1, IBond.Order.SINGLE);
        mol.addBond(9, 8, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeMethylDecaline() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 0, IBond.Order.SINGLE);
        mol.addBond(5, 10, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeEthylPropylPhenantren() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.DOUBLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.DOUBLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.DOUBLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.DOUBLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 0, IBond.Order.DOUBLE);
        mol.addBond(9, 4, IBond.Order.SINGLE);
        mol.addBond(8, 10, IBond.Order.SINGLE);
        mol.addBond(10, 11, IBond.Order.DOUBLE);
        mol.addBond(11, 12, IBond.Order.SINGLE);
        mol.addBond(12, 13, IBond.Order.DOUBLE);
        mol.addBond(13, 7, IBond.Order.SINGLE);
        mol.addBond(3, 14, IBond.Order.SINGLE);
        mol.addBond(14, 15, IBond.Order.SINGLE);
        mol.addBond(12, 16, IBond.Order.SINGLE);
        mol.addBond(16, 17, IBond.Order.SINGLE);
        mol.addBond(17, 18, IBond.Order.SINGLE);
        TestMoleculeFactory.configureAtoms(mol);
        return mol;
    }

    public static IAtomContainer makeSteran() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 0, IBond.Order.SINGLE);
        mol.addBond(9, 4, IBond.Order.SINGLE);
        mol.addBond(8, 10, IBond.Order.SINGLE);
        mol.addBond(10, 11, IBond.Order.SINGLE);
        mol.addBond(11, 12, IBond.Order.SINGLE);
        mol.addBond(12, 13, IBond.Order.SINGLE);
        mol.addBond(13, 7, IBond.Order.SINGLE);
        mol.addBond(13, 14, IBond.Order.SINGLE);
        mol.addBond(14, 15, IBond.Order.SINGLE);
        mol.addBond(15, 16, IBond.Order.SINGLE);
        mol.addBond(16, 12, IBond.Order.SINGLE);
        TestMoleculeFactory.configureAtoms(mol);
        return mol;
    }

    public static IAtomContainer makeAzulene() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.DOUBLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.DOUBLE);
        mol.addBond(9, 5, IBond.Order.SINGLE);
        mol.addBond(9, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeIndole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.DOUBLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(0, 5, IBond.Order.SINGLE);
        mol.addBond(8, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makePyrrole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePyrroleAnion() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        Atom nitrogenAnion = new Atom("N");
        nitrogenAnion.setFormalCharge(-1);
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)nitrogenAnion);
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeImidazole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePyrazole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer make124Triazole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer make123Triazole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeTetrazole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeOxazole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("O"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeIsoxazole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("O"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeIsothiazole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("S"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeThiadiazole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("S"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeOxadiazole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("O"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePyridine() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makePyridineOxide() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.getAtom(1).setFormalCharge(Integer.valueOf(1));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("O"));
        mol.getAtom(6).setFormalCharge(Integer.valueOf(-1));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(1, 6, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makePyrimidine() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makePyridazine() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeTriazine() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeThiazole() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("S"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.DOUBLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeSingleRing() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeDiamantane() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 9, IBond.Order.SINGLE);
        mol.addBond(1, 7, IBond.Order.SINGLE);
        mol.addBond(7, 9, IBond.Order.SINGLE);
        mol.addBond(3, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(0, 10, IBond.Order.SINGLE);
        mol.addBond(10, 13, IBond.Order.SINGLE);
        mol.addBond(2, 11, IBond.Order.SINGLE);
        mol.addBond(11, 13, IBond.Order.SINGLE);
        mol.addBond(4, 12, IBond.Order.SINGLE);
        mol.addBond(12, 13, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeBranchedAliphatic() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(2, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(6, 9, IBond.Order.SINGLE);
        mol.addBond(6, 10, IBond.Order.SINGLE);
        mol.addBond(10, 11, IBond.Order.SINGLE);
        mol.addBond(8, 12, IBond.Order.TRIPLE);
        mol.addBond(12, 13, IBond.Order.SINGLE);
        mol.addBond(11, 14, IBond.Order.SINGLE);
        mol.addBond(9, 15, IBond.Order.SINGLE);
        mol.addBond(15, 16, IBond.Order.DOUBLE);
        mol.addBond(16, 17, IBond.Order.DOUBLE);
        mol.addBond(17, 18, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeBenzene() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.DOUBLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.DOUBLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeQuinone() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("O"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("O"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.DOUBLE);
        mol.addBond(6, 1, IBond.Order.SINGLE);
        mol.addBond(4, 7, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePiperidine() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("H"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeTetrahydropyran() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        mol.addAtom((IAtom)new Atom("O"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeAdenine() {
        IAtomContainer mol = TestMoleculeFactory.newAtomContainer();
        IAtom a1 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"C"});
        a1.setPoint2d(new Point2d(21.0223, -17.2946));
        mol.addAtom(a1);
        IAtom a2 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"C"});
        a2.setPoint2d(new Point2d(21.0223, -18.8093));
        mol.addAtom(a2);
        IAtom a3 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"C"});
        a3.setPoint2d(new Point2d(22.1861, -16.6103));
        mol.addAtom(a3);
        IAtom a4 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"N"});
        a4.setPoint2d(new Point2d(19.8294, -16.8677));
        mol.addAtom(a4);
        IAtom a5 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"N"});
        a5.setPoint2d(new Point2d(22.2212, -19.5285));
        mol.addAtom(a5);
        IAtom a6 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"N"});
        a6.setPoint2d(new Point2d(19.8177, -19.2187));
        mol.addAtom(a6);
        IAtom a7 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"N"});
        a7.setPoint2d(new Point2d(23.4669, -17.3531));
        mol.addAtom(a7);
        IAtom a8 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"N"});
        a8.setPoint2d(new Point2d(22.1861, -15.2769));
        mol.addAtom(a8);
        IAtom a9 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"C"});
        a9.setPoint2d(new Point2d(18.9871, -18.0139));
        mol.addAtom(a9);
        IAtom a10 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"C"});
        a10.setPoint2d(new Point2d(23.4609, -18.8267));
        mol.addAtom(a10);
        IBond b1 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.DOUBLE});
        mol.addBond(b1);
        IBond b2 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a1, a3, IBond.Order.SINGLE});
        mol.addBond(b2);
        IBond b3 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a1, a4, IBond.Order.SINGLE});
        mol.addBond(b3);
        IBond b4 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a2, a5, IBond.Order.SINGLE});
        mol.addBond(b4);
        IBond b5 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a2, a6, IBond.Order.SINGLE});
        mol.addBond(b5);
        IBond b6 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a3, a7, IBond.Order.DOUBLE});
        mol.addBond(b6);
        IBond b7 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a3, a8, IBond.Order.SINGLE});
        mol.addBond(b7);
        IBond b8 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a4, a9, IBond.Order.DOUBLE});
        mol.addBond(b8);
        IBond b9 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a5, a10, IBond.Order.DOUBLE});
        mol.addBond(b9);
        IBond b10 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a6, a9, IBond.Order.SINGLE});
        mol.addBond(b10);
        IBond b11 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a7, a10, IBond.Order.SINGLE});
        mol.addBond(b11);
        return mol;
    }

    public static IAtomContainer makeNaphthalene() {
        IChemObjectBuilder builder = DefaultChemObjectBuilder.getInstance();
        IAtomContainer mol = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        IAtom a1 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a1.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a1);
        IAtom a2 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a2.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a2);
        IAtom a3 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a3.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a3);
        IAtom a4 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a4.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a4);
        IAtom a5 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a5.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a5);
        IAtom a6 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a6.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a6);
        IAtom a7 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a7.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a7);
        IAtom a8 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a8.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a8);
        IAtom a9 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a9.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a9);
        IAtom a10 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a10.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a10);
        IBond b1 = (IBond)builder.newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.DOUBLE});
        mol.addBond(b1);
        IBond b2 = (IBond)builder.newInstance(IBond.class, new Object[]{a2, a3, IBond.Order.SINGLE});
        mol.addBond(b2);
        IBond b3 = (IBond)builder.newInstance(IBond.class, new Object[]{a3, a4, IBond.Order.DOUBLE});
        mol.addBond(b3);
        IBond b4 = (IBond)builder.newInstance(IBond.class, new Object[]{a4, a5, IBond.Order.SINGLE});
        mol.addBond(b4);
        IBond b5 = (IBond)builder.newInstance(IBond.class, new Object[]{a5, a6, IBond.Order.DOUBLE});
        mol.addBond(b5);
        IBond b6 = (IBond)builder.newInstance(IBond.class, new Object[]{a6, a7, IBond.Order.SINGLE});
        mol.addBond(b6);
        IBond b7 = (IBond)builder.newInstance(IBond.class, new Object[]{a7, a8, IBond.Order.DOUBLE});
        mol.addBond(b7);
        IBond b8 = (IBond)builder.newInstance(IBond.class, new Object[]{a3, a8, IBond.Order.SINGLE});
        mol.addBond(b8);
        IBond b9 = (IBond)builder.newInstance(IBond.class, new Object[]{a8, a9, IBond.Order.SINGLE});
        mol.addBond(b9);
        IBond b10 = (IBond)builder.newInstance(IBond.class, new Object[]{a9, a10, IBond.Order.DOUBLE});
        mol.addBond(b10);
        IBond b11 = (IBond)builder.newInstance(IBond.class, new Object[]{a1, a10, IBond.Order.SINGLE});
        mol.addBond(b11);
        return mol;
    }

    public static IAtomContainer makeAnthracene() {
        IChemObjectBuilder builder = DefaultChemObjectBuilder.getInstance();
        IAtomContainer mol = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        IAtom a1 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a1.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a1);
        IAtom a2 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a2.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a2);
        IAtom a3 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a3.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a3);
        IAtom a4 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a4.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a4);
        IAtom a5 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a5.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a5);
        IAtom a6 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a6.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a6);
        IAtom a7 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a7.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a7);
        IAtom a8 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a8.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a8);
        IAtom a9 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a9.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a9);
        IAtom a10 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a10.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a10);
        IAtom a11 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a11.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a11);
        IAtom a12 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a12.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a12);
        IAtom a13 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a13.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a13);
        IAtom a14 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a14.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a14);
        IBond b1 = (IBond)builder.newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.DOUBLE});
        mol.addBond(b1);
        IBond b2 = (IBond)builder.newInstance(IBond.class, new Object[]{a2, a3, IBond.Order.SINGLE});
        mol.addBond(b2);
        IBond b3 = (IBond)builder.newInstance(IBond.class, new Object[]{a3, a4, IBond.Order.DOUBLE});
        mol.addBond(b3);
        IBond b4 = (IBond)builder.newInstance(IBond.class, new Object[]{a4, a5, IBond.Order.SINGLE});
        mol.addBond(b4);
        IBond b5 = (IBond)builder.newInstance(IBond.class, new Object[]{a5, a6, IBond.Order.DOUBLE});
        mol.addBond(b5);
        IBond b6 = (IBond)builder.newInstance(IBond.class, new Object[]{a6, a7, IBond.Order.SINGLE});
        mol.addBond(b6);
        IBond b7 = (IBond)builder.newInstance(IBond.class, new Object[]{a7, a8, IBond.Order.DOUBLE});
        mol.addBond(b7);
        IBond b8 = (IBond)builder.newInstance(IBond.class, new Object[]{a8, a9, IBond.Order.SINGLE});
        mol.addBond(b8);
        IBond b9 = (IBond)builder.newInstance(IBond.class, new Object[]{a9, a10, IBond.Order.DOUBLE});
        mol.addBond(b9);
        IBond b10 = (IBond)builder.newInstance(IBond.class, new Object[]{a5, a10, IBond.Order.SINGLE});
        mol.addBond(b10);
        IBond b11 = (IBond)builder.newInstance(IBond.class, new Object[]{a10, a11, IBond.Order.SINGLE});
        mol.addBond(b11);
        IBond b12 = (IBond)builder.newInstance(IBond.class, new Object[]{a11, a12, IBond.Order.DOUBLE});
        mol.addBond(b12);
        IBond b13 = (IBond)builder.newInstance(IBond.class, new Object[]{a3, a12, IBond.Order.SINGLE});
        mol.addBond(b13);
        IBond b14 = (IBond)builder.newInstance(IBond.class, new Object[]{a12, a13, IBond.Order.SINGLE});
        mol.addBond(b14);
        IBond b15 = (IBond)builder.newInstance(IBond.class, new Object[]{a13, a14, IBond.Order.DOUBLE});
        mol.addBond(b15);
        IBond b16 = (IBond)builder.newInstance(IBond.class, new Object[]{a1, a14, IBond.Order.SINGLE});
        mol.addBond(b16);
        return mol;
    }

    public static IAtomContainer makeCyclophaneLike() {
        IChemObjectBuilder builder = DefaultChemObjectBuilder.getInstance();
        IAtomContainer mol = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        IAtom a1 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a1.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a1);
        IAtom a2 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a2.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a2);
        IAtom a3 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a3.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a3);
        IAtom a4 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a4.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a4);
        IAtom a5 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a5.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a5);
        IAtom a6 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a6.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a6);
        IAtom a7 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a7.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a7);
        IAtom a8 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a8.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a8);
        IAtom a9 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a9.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a9);
        IAtom a10 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a10.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a10);
        IAtom a11 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a11.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a11);
        IAtom a12 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a12.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a12);
        IAtom a13 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a13.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a13);
        IAtom a14 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a14.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a14);
        IAtom a15 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a15.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a15);
        IAtom a16 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a16.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a16);
        IAtom a17 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a17.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a17);
        IAtom a18 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a18.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a18);
        IAtom a19 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a19.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a19);
        IAtom a20 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a20.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a20);
        IAtom a21 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a21.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a21);
        IAtom a22 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a22.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a22);
        IAtom a23 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a23.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a23);
        IAtom a24 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a24.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a24);
        IAtom a25 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a25.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a25);
        IAtom a26 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a26.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a26);
        IAtom a27 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a27.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a27);
        IAtom a28 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a28.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a28);
        IAtom a29 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a29.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a29);
        IAtom a30 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a30.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a30);
        IAtom a31 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a31.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a31);
        IAtom a32 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a32.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a32);
        IAtom a33 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a33.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a33);
        IAtom a34 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a34.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a34);
        IAtom a35 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a35.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a35);
        IBond b1 = (IBond)builder.newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.SINGLE});
        mol.addBond(b1);
        IBond b2 = (IBond)builder.newInstance(IBond.class, new Object[]{a2, a3, IBond.Order.SINGLE});
        mol.addBond(b2);
        IBond b3 = (IBond)builder.newInstance(IBond.class, new Object[]{a3, a4, IBond.Order.SINGLE});
        mol.addBond(b3);
        IBond b4 = (IBond)builder.newInstance(IBond.class, new Object[]{a4, a5, IBond.Order.SINGLE});
        mol.addBond(b4);
        IBond b5 = (IBond)builder.newInstance(IBond.class, new Object[]{a5, a6, IBond.Order.SINGLE});
        mol.addBond(b5);
        IBond b6 = (IBond)builder.newInstance(IBond.class, new Object[]{a1, a6, IBond.Order.SINGLE});
        mol.addBond(b6);
        IBond b7 = (IBond)builder.newInstance(IBond.class, new Object[]{a6, a7, IBond.Order.SINGLE});
        mol.addBond(b7);
        IBond b8 = (IBond)builder.newInstance(IBond.class, new Object[]{a7, a8, IBond.Order.SINGLE});
        mol.addBond(b8);
        IBond b9 = (IBond)builder.newInstance(IBond.class, new Object[]{a8, a9, IBond.Order.SINGLE});
        mol.addBond(b9);
        IBond b10 = (IBond)builder.newInstance(IBond.class, new Object[]{a9, a10, IBond.Order.SINGLE});
        mol.addBond(b10);
        IBond b11 = (IBond)builder.newInstance(IBond.class, new Object[]{a10, a11, IBond.Order.SINGLE});
        mol.addBond(b11);
        IBond b12 = (IBond)builder.newInstance(IBond.class, new Object[]{a6, a11, IBond.Order.SINGLE});
        mol.addBond(b12);
        IBond b13 = (IBond)builder.newInstance(IBond.class, new Object[]{a9, a12, IBond.Order.SINGLE});
        mol.addBond(b13);
        IBond b14 = (IBond)builder.newInstance(IBond.class, new Object[]{a12, a13, IBond.Order.SINGLE});
        mol.addBond(b14);
        IBond b15 = (IBond)builder.newInstance(IBond.class, new Object[]{a13, a14, IBond.Order.SINGLE});
        mol.addBond(b15);
        IBond b16 = (IBond)builder.newInstance(IBond.class, new Object[]{a14, a15, IBond.Order.SINGLE});
        mol.addBond(b16);
        IBond b17 = (IBond)builder.newInstance(IBond.class, new Object[]{a15, a16, IBond.Order.SINGLE});
        mol.addBond(b17);
        IBond b18 = (IBond)builder.newInstance(IBond.class, new Object[]{a9, a16, IBond.Order.SINGLE});
        mol.addBond(b18);
        IBond b19 = (IBond)builder.newInstance(IBond.class, new Object[]{a14, a17, IBond.Order.SINGLE});
        mol.addBond(b19);
        IBond b20 = (IBond)builder.newInstance(IBond.class, new Object[]{a17, a18, IBond.Order.SINGLE});
        mol.addBond(b20);
        IBond b21 = (IBond)builder.newInstance(IBond.class, new Object[]{a18, a19, IBond.Order.SINGLE});
        mol.addBond(b21);
        IBond b22 = (IBond)builder.newInstance(IBond.class, new Object[]{a19, a20, IBond.Order.SINGLE});
        mol.addBond(b22);
        IBond b23 = (IBond)builder.newInstance(IBond.class, new Object[]{a20, a21, IBond.Order.SINGLE});
        mol.addBond(b23);
        IBond b24 = (IBond)builder.newInstance(IBond.class, new Object[]{a14, a21, IBond.Order.SINGLE});
        mol.addBond(b24);
        IBond b25 = (IBond)builder.newInstance(IBond.class, new Object[]{a19, a22, IBond.Order.SINGLE});
        mol.addBond(b25);
        IBond b26 = (IBond)builder.newInstance(IBond.class, new Object[]{a22, a23, IBond.Order.SINGLE});
        mol.addBond(b26);
        IBond b27 = (IBond)builder.newInstance(IBond.class, new Object[]{a23, a24, IBond.Order.SINGLE});
        mol.addBond(b27);
        IBond b28 = (IBond)builder.newInstance(IBond.class, new Object[]{a24, a25, IBond.Order.SINGLE});
        mol.addBond(b28);
        IBond b29 = (IBond)builder.newInstance(IBond.class, new Object[]{a25, a26, IBond.Order.SINGLE});
        mol.addBond(b29);
        IBond b30 = (IBond)builder.newInstance(IBond.class, new Object[]{a26, a27, IBond.Order.SINGLE});
        mol.addBond(b30);
        IBond b31 = (IBond)builder.newInstance(IBond.class, new Object[]{a27, a28, IBond.Order.SINGLE});
        mol.addBond(b31);
        IBond b32 = (IBond)builder.newInstance(IBond.class, new Object[]{a28, a29, IBond.Order.SINGLE});
        mol.addBond(b32);
        IBond b33 = (IBond)builder.newInstance(IBond.class, new Object[]{a3, a29, IBond.Order.SINGLE});
        mol.addBond(b33);
        IBond b34 = (IBond)builder.newInstance(IBond.class, new Object[]{a27, a30, IBond.Order.SINGLE});
        mol.addBond(b34);
        IBond b35 = (IBond)builder.newInstance(IBond.class, new Object[]{a30, a31, IBond.Order.SINGLE});
        mol.addBond(b35);
        IBond b36 = (IBond)builder.newInstance(IBond.class, new Object[]{a3, a31, IBond.Order.SINGLE});
        mol.addBond(b36);
        IBond b37 = (IBond)builder.newInstance(IBond.class, new Object[]{a27, a32, IBond.Order.SINGLE});
        mol.addBond(b37);
        IBond b38 = (IBond)builder.newInstance(IBond.class, new Object[]{a32, a33, IBond.Order.SINGLE});
        mol.addBond(b38);
        IBond b39 = (IBond)builder.newInstance(IBond.class, new Object[]{a24, a33, IBond.Order.SINGLE});
        mol.addBond(b39);
        IBond b40 = (IBond)builder.newInstance(IBond.class, new Object[]{a24, a34, IBond.Order.SINGLE});
        mol.addBond(b40);
        IBond b41 = (IBond)builder.newInstance(IBond.class, new Object[]{a34, a35, IBond.Order.SINGLE});
        mol.addBond(b41);
        IBond b42 = (IBond)builder.newInstance(IBond.class, new Object[]{a19, a35, IBond.Order.SINGLE});
        mol.addBond(b42);
        return mol;
    }

    public static IAtomContainer makeGappedCyclophaneLike() {
        IChemObjectBuilder builder = DefaultChemObjectBuilder.getInstance();
        IAtomContainer mol = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        IAtom a1 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a1.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a1);
        IAtom a2 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a2.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a2);
        IAtom a3 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a3.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a3);
        IAtom a4 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a4.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a4);
        IAtom a5 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a5.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a5);
        IAtom a6 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a6.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a6);
        IAtom a7 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a7.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a7);
        IAtom a8 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a8.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a8);
        IAtom a9 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a9.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a9);
        IAtom a10 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a10.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a10);
        IAtom a11 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a11.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a11);
        IAtom a12 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a12.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a12);
        IAtom a13 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a13.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a13);
        IAtom a14 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a14.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a14);
        IAtom a15 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a15.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a15);
        IAtom a16 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a16.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a16);
        IAtom a17 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a17.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a17);
        IAtom a18 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a18.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a18);
        IAtom a19 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a19.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a19);
        IAtom a20 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a20.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a20);
        IAtom a21 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a21.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a21);
        IAtom a22 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a22.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a22);
        IAtom a23 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a23.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a23);
        IAtom a24 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a24.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a24);
        IAtom a25 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a25.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a25);
        IAtom a26 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a26.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a26);
        IAtom a27 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a27.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a27);
        IAtom a28 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a28.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a28);
        IAtom a29 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a29.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a29);
        IAtom a30 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a30.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a30);
        IAtom a31 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a31.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a31);
        IAtom a32 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a32.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a32);
        IAtom a33 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a33.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a33);
        IAtom a34 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a34.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a34);
        IAtom a35 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a35.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a35);
        IAtom a36 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a36.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a36);
        IAtom a37 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a37.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a37);
        IAtom a38 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a38.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a38);
        IAtom a39 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a39.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a39);
        IAtom a40 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a40.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a40);
        IAtom a41 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a41.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a41);
        IAtom a42 = (IAtom)builder.newInstance(IAtom.class, new Object[]{"C"});
        a42.setFormalCharge(Integer.valueOf(0));
        mol.addAtom(a42);
        IBond b1 = (IBond)builder.newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.SINGLE});
        mol.addBond(b1);
        IBond b2 = (IBond)builder.newInstance(IBond.class, new Object[]{a2, a3, IBond.Order.SINGLE});
        mol.addBond(b2);
        IBond b3 = (IBond)builder.newInstance(IBond.class, new Object[]{a3, a4, IBond.Order.SINGLE});
        mol.addBond(b3);
        IBond b4 = (IBond)builder.newInstance(IBond.class, new Object[]{a4, a5, IBond.Order.SINGLE});
        mol.addBond(b4);
        IBond b5 = (IBond)builder.newInstance(IBond.class, new Object[]{a5, a6, IBond.Order.SINGLE});
        mol.addBond(b5);
        IBond b6 = (IBond)builder.newInstance(IBond.class, new Object[]{a1, a6, IBond.Order.SINGLE});
        mol.addBond(b6);
        IBond b7 = (IBond)builder.newInstance(IBond.class, new Object[]{a6, a7, IBond.Order.SINGLE});
        mol.addBond(b7);
        IBond b8 = (IBond)builder.newInstance(IBond.class, new Object[]{a7, a8, IBond.Order.SINGLE});
        mol.addBond(b8);
        IBond b9 = (IBond)builder.newInstance(IBond.class, new Object[]{a8, a9, IBond.Order.SINGLE});
        mol.addBond(b9);
        IBond b10 = (IBond)builder.newInstance(IBond.class, new Object[]{a9, a10, IBond.Order.SINGLE});
        mol.addBond(b10);
        IBond b11 = (IBond)builder.newInstance(IBond.class, new Object[]{a10, a11, IBond.Order.SINGLE});
        mol.addBond(b11);
        IBond b12 = (IBond)builder.newInstance(IBond.class, new Object[]{a11, a12, IBond.Order.SINGLE});
        mol.addBond(b12);
        IBond b13 = (IBond)builder.newInstance(IBond.class, new Object[]{a7, a12, IBond.Order.SINGLE});
        mol.addBond(b13);
        IBond b14 = (IBond)builder.newInstance(IBond.class, new Object[]{a10, a13, IBond.Order.SINGLE});
        mol.addBond(b14);
        IBond b15 = (IBond)builder.newInstance(IBond.class, new Object[]{a13, a14, IBond.Order.SINGLE});
        mol.addBond(b15);
        IBond b16 = (IBond)builder.newInstance(IBond.class, new Object[]{a14, a15, IBond.Order.SINGLE});
        mol.addBond(b16);
        IBond b17 = (IBond)builder.newInstance(IBond.class, new Object[]{a15, a16, IBond.Order.SINGLE});
        mol.addBond(b17);
        IBond b18 = (IBond)builder.newInstance(IBond.class, new Object[]{a16, a17, IBond.Order.SINGLE});
        mol.addBond(b18);
        IBond b19 = (IBond)builder.newInstance(IBond.class, new Object[]{a17, a18, IBond.Order.SINGLE});
        mol.addBond(b19);
        IBond b20 = (IBond)builder.newInstance(IBond.class, new Object[]{a13, a18, IBond.Order.SINGLE});
        mol.addBond(b20);
        IBond b21 = (IBond)builder.newInstance(IBond.class, new Object[]{a16, a19, IBond.Order.SINGLE});
        mol.addBond(b21);
        IBond b22 = (IBond)builder.newInstance(IBond.class, new Object[]{a19, a20, IBond.Order.SINGLE});
        mol.addBond(b22);
        IBond b23 = (IBond)builder.newInstance(IBond.class, new Object[]{a20, a21, IBond.Order.SINGLE});
        mol.addBond(b23);
        IBond b24 = (IBond)builder.newInstance(IBond.class, new Object[]{a21, a22, IBond.Order.SINGLE});
        mol.addBond(b24);
        IBond b25 = (IBond)builder.newInstance(IBond.class, new Object[]{a22, a23, IBond.Order.SINGLE});
        mol.addBond(b25);
        IBond b26 = (IBond)builder.newInstance(IBond.class, new Object[]{a23, a24, IBond.Order.SINGLE});
        mol.addBond(b26);
        IBond b27 = (IBond)builder.newInstance(IBond.class, new Object[]{a19, a24, IBond.Order.SINGLE});
        mol.addBond(b27);
        IBond b28 = (IBond)builder.newInstance(IBond.class, new Object[]{a22, a25, IBond.Order.SINGLE});
        mol.addBond(b28);
        IBond b29 = (IBond)builder.newInstance(IBond.class, new Object[]{a25, a26, IBond.Order.SINGLE});
        mol.addBond(b29);
        IBond b30 = (IBond)builder.newInstance(IBond.class, new Object[]{a26, a27, IBond.Order.SINGLE});
        mol.addBond(b30);
        IBond b31 = (IBond)builder.newInstance(IBond.class, new Object[]{a27, a28, IBond.Order.SINGLE});
        mol.addBond(b31);
        IBond b32 = (IBond)builder.newInstance(IBond.class, new Object[]{a28, a29, IBond.Order.SINGLE});
        mol.addBond(b32);
        IBond b33 = (IBond)builder.newInstance(IBond.class, new Object[]{a29, a30, IBond.Order.SINGLE});
        mol.addBond(b33);
        IBond b34 = (IBond)builder.newInstance(IBond.class, new Object[]{a25, a30, IBond.Order.SINGLE});
        mol.addBond(b34);
        IBond b35 = (IBond)builder.newInstance(IBond.class, new Object[]{a28, a31, IBond.Order.SINGLE});
        mol.addBond(b35);
        IBond b36 = (IBond)builder.newInstance(IBond.class, new Object[]{a31, a32, IBond.Order.SINGLE});
        mol.addBond(b36);
        IBond b37 = (IBond)builder.newInstance(IBond.class, new Object[]{a32, a33, IBond.Order.SINGLE});
        mol.addBond(b37);
        IBond b38 = (IBond)builder.newInstance(IBond.class, new Object[]{a33, a34, IBond.Order.SINGLE});
        mol.addBond(b38);
        IBond b39 = (IBond)builder.newInstance(IBond.class, new Object[]{a34, a35, IBond.Order.SINGLE});
        mol.addBond(b39);
        IBond b40 = (IBond)builder.newInstance(IBond.class, new Object[]{a35, a36, IBond.Order.SINGLE});
        mol.addBond(b40);
        IBond b41 = (IBond)builder.newInstance(IBond.class, new Object[]{a31, a36, IBond.Order.SINGLE});
        mol.addBond(b41);
        IBond b42 = (IBond)builder.newInstance(IBond.class, new Object[]{a34, a37, IBond.Order.SINGLE});
        mol.addBond(b42);
        IBond b43 = (IBond)builder.newInstance(IBond.class, new Object[]{a37, a38, IBond.Order.SINGLE});
        mol.addBond(b43);
        IBond b44 = (IBond)builder.newInstance(IBond.class, new Object[]{a38, a39, IBond.Order.SINGLE});
        mol.addBond(b44);
        IBond b45 = (IBond)builder.newInstance(IBond.class, new Object[]{a39, a40, IBond.Order.SINGLE});
        mol.addBond(b45);
        IBond b46 = (IBond)builder.newInstance(IBond.class, new Object[]{a3, a40, IBond.Order.SINGLE});
        mol.addBond(b46);
        IBond b47 = (IBond)builder.newInstance(IBond.class, new Object[]{a40, a41, IBond.Order.SINGLE});
        mol.addBond(b47);
        IBond b48 = (IBond)builder.newInstance(IBond.class, new Object[]{a41, a42, IBond.Order.SINGLE});
        mol.addBond(b48);
        IBond b49 = (IBond)builder.newInstance(IBond.class, new Object[]{a37, a42, IBond.Order.SINGLE});
        mol.addBond(b49);
        return mol;
    }

    private static void configureAtoms(IAtomContainer mol) {
        try {
            for (IAtom atom : mol.atoms()) {
                atom.setImplicitHydrogenCount(null);
            }
            Isotopes.getInstance().configureAtoms(mol);
        }
        catch (Exception exc) {
            logger.error((Object)"Could not configure molecule!");
            logger.debug((Object)exc);
        }
    }
}

