/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.MDLV3000Writer;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SDFFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class SDFWriter
extends DefaultChemObjectWriter {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(SDFWriter.class);
    public static final String OptAlwaysV3000 = "writeV3000";
    public static final String OptWriteData = "writeProperties";
    public static final String OptTruncateLongData = "TruncateLongData";
    private BufferedWriter writer;
    private BooleanIOSetting paramWriteData;
    private BooleanIOSetting paramWriteV3000;
    private BooleanIOSetting truncateData;
    private Set<String> propertiesToWrite;
    private static List<String> cdkInternalProperties = new ArrayList<String>();

    public SDFWriter(BufferedWriter wtr) {
        this.writer = wtr;
        this.initIOSettings();
    }

    public SDFWriter(Writer wtr) {
        this(SDFWriter.ensureBuffered(wtr));
        this.initIOSettings();
    }

    public SDFWriter(OutputStream output) {
        this(new OutputStreamWriter(output, StandardCharsets.UTF_8));
    }

    public SDFWriter() {
        this(new StringWriter());
    }

    public SDFWriter(Writer out, Set<String> propertiesToWrite) {
        this(out);
        this.initIOSettings();
        this.propertiesToWrite = propertiesToWrite;
    }

    public SDFWriter(OutputStream output, Set<String> propertiesToWrite) {
        this(new OutputStreamWriter(output), propertiesToWrite);
    }

    public SDFWriter(Set<String> propertiesToWrite) {
        this(new StringWriter(), propertiesToWrite);
    }

    private static BufferedWriter ensureBuffered(Writer wtr) {
        if (wtr == null) {
            throw new NullPointerException("Provided writer was null");
        }
        return wtr instanceof BufferedWriter ? (BufferedWriter)wtr : new BufferedWriter(wtr);
    }

    public IResourceFormat getFormat() {
        return SDFFormat.getInstance();
    }

    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IAtomContainer.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemFile.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemModel.class.equals(interfaces[i])) {
                return true;
            }
            if (!IAtomContainerSet.class.equals(interfaces[i])) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        if (IAtomContainerSet.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public void write(IChemObject object) throws CDKException {
        try {
            if (object instanceof IAtomContainerSet) {
                this.writeMoleculeSet((IAtomContainerSet)object);
                return;
            }
            if (object instanceof IChemFile) {
                this.writeChemFile((IChemFile)object);
                return;
            }
            if (object instanceof IChemModel) {
                this.writeChemModel((IChemModel)object);
                return;
            }
            if (object instanceof IAtomContainer) {
                this.writeMolecule((IAtomContainer)object);
                return;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            logger.debug((Object)ex);
            throw new CDKException("Exception while writing MDL file: " + ex.getMessage(), (Throwable)ex);
        }
        throw new CDKException("Only supported is writing of ChemFile, MoleculeSet, AtomContainer and Molecule objects.");
    }

    private void writeMoleculeSet(IAtomContainerSet som) throws Exception {
        for (IAtomContainer mol : som.atomContainers()) {
            this.writeMolecule(mol);
        }
    }

    private void writeChemFile(IChemFile file) throws Exception {
        for (IAtomContainer container : ChemFileManipulator.getAllAtomContainers((IChemFile)file)) {
            this.writeMolecule(container);
        }
    }

    private void writeChemModel(IChemModel model) throws Exception {
        for (IAtomContainer container : ChemModelManipulator.getAllAtomContainers((IChemModel)model)) {
            this.writeMolecule(container);
        }
    }

    private static String replaceInvalidHeaderChars(String headerKey) {
        return headerKey.replaceAll("[-<>.=% ]", "_");
    }

    private void writeMolecule(IAtomContainer container) throws CDKException {
        try {
            StringWriter stringWriter = new StringWriter();
            DefaultChemObjectWriter mdlWriter = this.writeV3000(container) ? new MDLV3000Writer(stringWriter) : new MDLV2000Writer(stringWriter);
            mdlWriter.addSettings(this.getSettings());
            mdlWriter.write((IChemObject)container);
            mdlWriter.close();
            this.writer.write(stringWriter.toString());
            if (this.paramWriteData.isSet()) {
                boolean writeAllProperties;
                Map sdFields = container.getProperties();
                boolean bl = writeAllProperties = this.propertiesToWrite == null;
                if (sdFields != null) {
                    for (Object propKey : sdFields.keySet()) {
                        Object val;
                        String headerKey = propKey.toString();
                        if (this.isCDKInternalProperty(headerKey) || !writeAllProperties && !this.propertiesToWrite.contains(headerKey)) continue;
                        String cleanHeaderKey = SDFWriter.replaceInvalidHeaderChars(headerKey);
                        if (!cleanHeaderKey.equals(headerKey)) {
                            logger.info((Object)"Replaced characters in SDfile data header: ", new Object[]{headerKey, " written as: ", cleanHeaderKey});
                        }
                        if (SDFWriter.isPrimitiveDataValue(val = sdFields.get(propKey))) {
                            this.writer.write("> <" + cleanHeaderKey + ">");
                            this.writer.write(10);
                            if (val != null) {
                                String valStr = val.toString();
                                int maxDataLen = 200;
                                if (this.truncateData.isSet()) {
                                    for (String line : valStr.split("\n")) {
                                        if (line.length() > maxDataLen) {
                                            this.writer.write(line.substring(0, maxDataLen));
                                            continue;
                                        }
                                        this.writer.write(valStr);
                                    }
                                } else {
                                    this.writer.write(valStr);
                                }
                            }
                            this.writer.write(10);
                            this.writer.write(10);
                            continue;
                        }
                        logger.info((Object)("Skipped property " + propKey + " because only primitive and string properties can be written by SDFWriter"));
                    }
                }
            }
            this.writer.write("$$$$\n");
        }
        catch (IOException exception) {
            throw new CDKException("Error while writing a SD file entry: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private static boolean isPrimitiveDataValue(Object obj) {
        return obj == null || obj.getClass() == String.class || obj.getClass() == Integer.class || obj.getClass() == Double.class || obj.getClass() == Boolean.class || obj.getClass() == Float.class || obj.getClass() == Byte.class || obj.getClass() == Short.class || obj.getClass() == Character.class;
    }

    private boolean writeV3000(IAtomContainer container) {
        if (this.paramWriteV3000.isSet()) {
            return true;
        }
        if (container.getAtomCount() > 999) {
            return true;
        }
        if (container.getBondCount() > 999) {
            return true;
        }
        boolean init = false;
        int grp = 0;
        for (IStereoElement se : container.stereoElements()) {
            if (se.getConfigClass() != 16896) continue;
            if (!init) {
                init = true;
                grp = se.getGroupInfo();
                continue;
            }
            if (grp == se.getGroupInfo()) continue;
            return true;
        }
        if ((grp & 0x30000) == 131072) {
            return true;
        }
        List sgroups = (List)container.getProperty((Object)"cdk:CtabSgroups");
        if (sgroups != null) {
            for (Sgroup sgroup : sgroups) {
                if (sgroup.getType() != SgroupType.ExtMulticenter) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCDKInternalProperty(Object propKey) {
        return cdkInternalProperties.contains(propKey);
    }

    private void initIOSettings() {
        this.paramWriteData = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting(OptWriteData, IOSetting.Importance.LOW, "Should molecule properties be written as non-structural data", "true"));
        this.paramWriteV3000 = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting(OptAlwaysV3000, IOSetting.Importance.LOW, "Write all records as V3000", "false"));
        this.truncateData = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting(OptTruncateLongData, IOSetting.Importance.LOW, "Truncate long data files >200 characters", "false"));
        this.addSettings(new MDLV2000Writer().getSettings());
        this.addSettings(new MDLV3000Writer().getSettings());
    }

    public void setAlwaysV3000(boolean val) {
        try {
            this.paramWriteV3000.setSetting(Boolean.toString(val));
        }
        catch (CDKException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public void customizeJob() {
        for (IOSetting setting : this.getSettings()) {
            this.fireIOSettingQuestion(setting);
        }
    }

    static {
        cdkInternalProperties.add("CanonicalLabel");
        cdkInternalProperties.add("InvariancePair");
        cdkInternalProperties.add("cdk:CtabSgroups");
        cdkInternalProperties.add("cdk:Remark");
        cdkInternalProperties.add("cdk:Title");
    }
}

