/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.java.tree.VariableDeclarator;
import org.openrewrite.marker.Markers;

public class MergeSpacesVisitor
extends JavaVisitor<Object> {
    @Override
    public boolean isAcceptable(SourceFile sourceFile, @Nullable Object ctx) {
        return sourceFile instanceof JavaSourceFile;
    }

    @Override
    public String getLanguage() {
        return "java";
    }

    @Override
    public Space visitSpace(@Nullable Space space, Space.Location loc, @Nullable Object ctx) {
        if (space == ctx || !(ctx instanceof Space)) {
            return space;
        }
        Space newSpace = (Space)ctx;
        if (space == null) {
            return newSpace;
        }
        if ((space = space.withWhitespace(newSpace.getWhitespace())).getComments().isEmpty() || space.getComments().size() != newSpace.getComments().size()) {
            return space;
        }
        return space.withComments(ListUtils.map(space.getComments(), (index, comment) -> {
            if (comment instanceof Javadoc.DocComment) {
                Javadoc.DocComment docComment = (Javadoc.DocComment)comment;
                if (!(newSpace.getComments().get((int)index) instanceof Javadoc.DocComment)) {
                    return docComment;
                }
                Javadoc.DocComment replaceWith = (Javadoc.DocComment)newSpace.getComments().get((int)index);
                comment = docComment.withBody(ListUtils.map(docComment.getBody(), (i, jdoc) -> {
                    if (!(jdoc instanceof Javadoc.LineBreak) || !(replaceWith.getBody().get((int)i) instanceof Javadoc.LineBreak)) {
                        return jdoc;
                    }
                    return ((Javadoc.LineBreak)jdoc).withMargin(((Javadoc.LineBreak)replaceWith.getBody().get((int)i)).getMargin());
                }));
            } else if (comment instanceof TextComment && newSpace.getComments().get((int)index) instanceof TextComment) {
                comment = ((TextComment)comment).withText(((TextComment)newSpace.getComments().get((int)index)).getText());
            }
            return comment.withSuffix(newSpace.getComments().get((int)index).getSuffix());
        }));
    }

    @Override
    public <N extends NameTree> N visitTypeName(N nameTree, @Nullable Object ctx) {
        NameTree newNameTree = (NameTree)ctx;
        if (nameTree == newNameTree) {
            return nameTree;
        }
        return nameTree;
    }

    @Override
    private <N extends NameTree> @Nullable JLeftPadded<N> visitTypeName(@Nullable JLeftPadded<N> nameTree, @Nullable Object ctx) {
        JLeftPadded newNameTree = (JLeftPadded)ctx;
        if (nameTree == newNameTree) {
            return nameTree;
        }
        return nameTree == null ? null : nameTree.withElement(this.visitTypeName((N)((NameTree)nameTree.getElement()), (Object)(newNameTree == null ? null : newNameTree.getElement())));
    }

    @Override
    private <N extends NameTree> @Nullable JRightPadded<N> visitTypeName(@Nullable JRightPadded<N> nameTree, @Nullable Object ctx) {
        JRightPadded newNameTree = (JRightPadded)ctx;
        if (nameTree == newNameTree) {
            return nameTree;
        }
        return nameTree == null ? null : nameTree.withElement(this.visitTypeName((N)((NameTree)nameTree.getElement()), (Object)(newNameTree == null ? null : newNameTree.getElement())));
    }

    private <J2 extends J> @Nullable JContainer<J2> visitTypeNames(@Nullable JContainer<J2> nameTrees, @Nullable Object ctx) {
        JContainer newNameTrees = (JContainer)ctx;
        if (nameTrees == newNameTrees) {
            return nameTrees;
        }
        if (nameTrees == null) {
            return null;
        }
        List js = ListUtils.map(nameTrees.getPadding().getElements(), (index, t) -> t.getElement() instanceof NameTree ? this.visitTypeName((JRightPadded)t, (Object)(newNameTrees == null ? null : newNameTrees.getPadding().getElements().get((int)index))) : t);
        return js == nameTrees.getPadding().getElements() ? nameTrees : JContainer.build(nameTrees.getBefore(), js, Markers.EMPTY);
    }

    @Override
    public J visitAnnotatedType(J.AnnotatedType annotatedType, @Nullable Object ctx) {
        if (annotatedType == ctx || !(ctx instanceof J.AnnotatedType)) {
            return annotatedType;
        }
        J.AnnotatedType newAnnotatedType = (J.AnnotatedType)ctx;
        J.AnnotatedType a = annotatedType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATED_TYPE_PREFIX, newAnnotatedType.getPrefix()));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newAnnotatedType.getMarkers())), newAnnotatedType);
        if (!(temp instanceof J.AnnotatedType)) {
            return temp;
        }
        a = (J.AnnotatedType)temp;
        a = a.withAnnotations(ListUtils.map(a.getAnnotations(), (index, e) -> (J.Annotation)this.visitAndCast((Tree)e, newAnnotatedType.getAnnotations().get((int)index))));
        a = a.withTypeExpression((TypeTree)this.visitAndCast(a.getTypeExpression(), newAnnotatedType.getTypeExpression()));
        return a.withTypeExpression(this.visitTypeName((N)a.getTypeExpression(), (Object)newAnnotatedType.getTypeExpression()));
    }

    @Override
    public J visitAnnotation(J.Annotation annotation, @Nullable Object ctx) {
        if (annotation == ctx || !(ctx instanceof J.Annotation)) {
            return annotation;
        }
        J.Annotation newAnnotation = (J.Annotation)ctx;
        J.Annotation a = annotation;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATION_PREFIX, newAnnotation.getPrefix()));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newAnnotation.getMarkers())), newAnnotation);
        if (!(temp instanceof J.Annotation)) {
            return temp;
        }
        a = (J.Annotation)temp;
        if (a.getPadding().getArguments() != null && newAnnotation.getPadding().getArguments() != null) {
            a = a.getPadding().withArguments(this.visitContainer((JContainer<J2>)a.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, newAnnotation.getPadding().getArguments()));
        }
        a = a.withAnnotationType((NameTree)this.visitAndCast(a.getAnnotationType(), newAnnotation.getAnnotationType()));
        return a.withAnnotationType(this.visitTypeName((N)a.getAnnotationType(), (Object)newAnnotation.getAnnotationType()));
    }

    @Override
    public J visitArrayAccess(J.ArrayAccess arrayAccess, @Nullable Object ctx) {
        if (arrayAccess == ctx || !(ctx instanceof J.ArrayAccess)) {
            return arrayAccess;
        }
        J.ArrayAccess newArrayAccess = (J.ArrayAccess)ctx;
        J.ArrayAccess a = arrayAccess;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ARRAY_ACCESS_PREFIX, newArrayAccess.getPrefix()));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newArrayAccess.getMarkers())), newArrayAccess);
        if (!(temp instanceof J.ArrayAccess)) {
            return temp;
        }
        a = (J.ArrayAccess)temp;
        a = a.withIndexed((Expression)this.visitAndCast(a.getIndexed(), newArrayAccess.getIndexed()));
        a = a.withDimension((J.ArrayDimension)this.visitAndCast(a.getDimension(), newArrayAccess.getDimension()));
        return a.withType(this.visitType(a.getType(), newArrayAccess.getType()));
    }

    @Override
    public J visitArrayDimension(J.ArrayDimension arrayDimension, @Nullable Object ctx) {
        if (arrayDimension == ctx || !(ctx instanceof J.ArrayDimension)) {
            return arrayDimension;
        }
        J.ArrayDimension newArrayDimension = (J.ArrayDimension)ctx;
        J.ArrayDimension a = arrayDimension;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.DIMENSION_PREFIX, newArrayDimension.getPrefix()));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), newArrayDimension.getMarkers()));
        return a.getPadding().withIndex(this.visitRightPadded((JRightPadded<T>)a.getPadding().getIndex(), JRightPadded.Location.ARRAY_INDEX, newArrayDimension.getPadding().getIndex()));
    }

    @Override
    public J visitArrayType(J.ArrayType arrayType, @Nullable Object ctx) {
        if (arrayType == ctx || !(ctx instanceof J.ArrayType)) {
            return arrayType;
        }
        J.ArrayType newArrayType = (J.ArrayType)ctx;
        J.ArrayType a = arrayType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ARRAY_TYPE_PREFIX, newArrayType.getPrefix()));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newArrayType.getMarkers())), newArrayType);
        if (!(temp instanceof J.ArrayType)) {
            return temp;
        }
        a = (J.ArrayType)temp;
        a = a.withElementType((TypeTree)this.visitAndCast(a.getElementType(), newArrayType.getElementType()));
        a = a.withElementType(this.visitTypeName((N)a.getElementType(), (Object)newArrayType.getElementType()));
        if ((a = a.withAnnotations(ListUtils.map(a.getAnnotations(), (index, ann) -> (J.Annotation)this.visitAndCast((Tree)ann, newArrayType.getAnnotations().get((int)index))))).getDimension() != null && newArrayType.getDimension() != null) {
            a = a.withDimension(a.getDimension().withBefore(this.visitSpace(a.getDimension().getBefore(), Space.Location.DIMENSION_PREFIX, newArrayType.getDimension().getBefore())).withElement(this.visitSpace(a.getDimension().getElement(), Space.Location.DIMENSION, newArrayType.getDimension().getElement())));
        }
        return a.withType(this.visitType(a.getType(), newArrayType.getType()));
    }

    @Override
    public J visitAssert(J.Assert assert_, @Nullable Object ctx) {
        if (assert_ == ctx || !(ctx instanceof J.Assert)) {
            return assert_;
        }
        J.Assert newAssert = (J.Assert)ctx;
        J.Assert a = assert_;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSERT_PREFIX, newAssert.getPrefix()));
        Statement temp = (Statement)this.visitStatement(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newAssert.getMarkers())), newAssert);
        if (!(temp instanceof J.Assert)) {
            return temp;
        }
        a = (J.Assert)temp;
        if ((a = a.withCondition((Expression)this.visitAndCast(a.getCondition(), newAssert.getCondition()))).getDetail() != null && newAssert.getDetail() != null) {
            a = a.withDetail(this.visitLeftPadded((JLeftPadded<T>)a.getDetail(), JLeftPadded.Location.ASSERT_DETAIL, newAssert.getDetail()));
        }
        return a;
    }

    @Override
    public J visitAssignment(J.Assignment assignment, @Nullable Object ctx) {
        if (assignment == ctx || !(ctx instanceof J.Assignment)) {
            return assignment;
        }
        J.Assignment newAssignment = (J.Assignment)ctx;
        J.Assignment a = assignment;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSIGNMENT_PREFIX, newAssignment.getPrefix()));
        Statement temp = (Statement)this.visitStatement(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newAssignment.getMarkers())), newAssignment);
        if (!(temp instanceof J.Assignment)) {
            return temp;
        }
        a = (J.Assignment)temp;
        Expression temp2 = (Expression)this.visitExpression(a, newAssignment);
        if (!(temp2 instanceof J.Assignment)) {
            return temp2;
        }
        a = (J.Assignment)temp2;
        a = a.withVariable((Expression)this.visitAndCast(a.getVariable(), newAssignment.getVariable()));
        a = a.getPadding().withAssignment(this.visitLeftPadded((JLeftPadded<T>)a.getPadding().getAssignment(), JLeftPadded.Location.ASSIGNMENT, newAssignment.getPadding().getAssignment()));
        return a.withType(this.visitType(a.getType(), newAssignment.getType()));
    }

    @Override
    public J visitAssignmentOperation(J.AssignmentOperation assignOp, @Nullable Object ctx) {
        if (assignOp == ctx || !(ctx instanceof J.AssignmentOperation)) {
            return assignOp;
        }
        J.AssignmentOperation newAssignOp = (J.AssignmentOperation)ctx;
        J.AssignmentOperation a = assignOp;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSIGNMENT_OPERATION_PREFIX, newAssignOp.getPrefix()));
        Statement temp = (Statement)this.visitStatement(a = a.withMarkers(this.visitMarkers(a.getMarkers(), newAssignOp.getMarkers())), newAssignOp);
        if (!(temp instanceof J.AssignmentOperation)) {
            return temp;
        }
        a = (J.AssignmentOperation)temp;
        Expression temp2 = (Expression)this.visitExpression(a, newAssignOp);
        if (!(temp2 instanceof J.AssignmentOperation)) {
            return temp2;
        }
        a = (J.AssignmentOperation)temp2;
        a = a.withVariable((Expression)this.visitAndCast(a.getVariable(), newAssignOp.getVariable()));
        a = a.getPadding().withOperator(this.visitLeftPadded((JLeftPadded<T>)a.getPadding().getOperator(), JLeftPadded.Location.ASSIGNMENT_OPERATION_OPERATOR, newAssignOp.getPadding().getOperator()));
        a = a.withAssignment((Expression)this.visitAndCast(a.getAssignment(), newAssignOp.getAssignment()));
        return a.withType(this.visitType(a.getType(), newAssignOp.getType()));
    }

    @Override
    public J visitBinary(J.Binary binary, @Nullable Object ctx) {
        if (binary == ctx || !(ctx instanceof J.Binary)) {
            return binary;
        }
        J.Binary newBinary = (J.Binary)ctx;
        J.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BINARY_PREFIX, newBinary.getPrefix()));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), newBinary.getMarkers())), newBinary);
        if (!(temp instanceof J.Binary)) {
            return temp;
        }
        b = (J.Binary)temp;
        b = b.withLeft((Expression)this.visitAndCast(b.getLeft(), newBinary.getLeft()));
        b = b.getPadding().withOperator(this.visitLeftPadded((JLeftPadded<T>)b.getPadding().getOperator(), JLeftPadded.Location.BINARY_OPERATOR, newBinary.getPadding().getOperator()));
        b = b.withRight((Expression)this.visitAndCast(b.getRight(), newBinary.getRight()));
        return b.withType(this.visitType(b.getType(), newBinary.getType()));
    }

    @Override
    public J visitBlock(J.Block block, @Nullable Object ctx) {
        if (block == ctx || !(ctx instanceof J.Block)) {
            return block;
        }
        J.Block newBlock = (J.Block)ctx;
        J.Block b = block;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BLOCK_PREFIX, newBlock.getPrefix()));
        Statement temp = (Statement)this.visitStatement(b = b.withMarkers(this.visitMarkers(b.getMarkers(), newBlock.getMarkers())), newBlock);
        if (!(temp instanceof J.Block)) {
            return temp;
        }
        b = (J.Block)temp;
        b = b.getPadding().withStatic(this.visitRightPadded((JRightPadded<T>)b.getPadding().getStatic(), JRightPadded.Location.STATIC_INIT, newBlock.getPadding().getStatic()));
        b = b.getPadding().withStatements(ListUtils.map(b.getPadding().getStatements(), (index, t) -> this.visitRightPadded((JRightPadded<T>)((JRightPadded)t), JRightPadded.Location.BLOCK_STATEMENT, newBlock.getPadding().getStatements().get((int)index))));
        return b.withEnd(this.visitSpace(b.getEnd(), Space.Location.BLOCK_END, newBlock.getEnd()));
    }

    @Override
    public J visitBreak(J.Break breakStatement, @Nullable Object ctx) {
        if (breakStatement == ctx || !(ctx instanceof J.Break)) {
            return breakStatement;
        }
        J.Break newBreakStatement = (J.Break)ctx;
        J.Break b = breakStatement;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BREAK_PREFIX, newBreakStatement.getPrefix()));
        Statement temp = (Statement)this.visitStatement(b = b.withMarkers(this.visitMarkers(b.getMarkers(), newBreakStatement.getMarkers())), newBreakStatement);
        if (!(temp instanceof J.Break)) {
            return temp;
        }
        b = (J.Break)temp;
        return b.withLabel((J.Identifier)this.visitAndCast(b.getLabel(), newBreakStatement.getLabel()));
    }

    @Override
    public J visitCase(J.Case case_, @Nullable Object ctx) {
        if (case_ == ctx || !(ctx instanceof J.Case)) {
            return case_;
        }
        J.Case newCase = (J.Case)ctx;
        J.Case c = case_;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CASE_PREFIX, newCase.getPrefix()));
        Statement temp = (Statement)this.visitStatement(c = c.withMarkers(this.visitMarkers(c.getMarkers(), newCase.getMarkers())), newCase);
        if (!(temp instanceof J.Case)) {
            return temp;
        }
        c = (J.Case)temp;
        c = c.getPadding().withCaseLabels(this.visitContainer((JContainer<J2>)c.getPadding().getCaseLabels(), JContainer.Location.CASE_LABEL, newCase.getPadding().getCaseLabels()));
        c = c.withGuard((Expression)this.visitAndCast(c.getGuard(), newCase.getGuard()));
        c = c.getPadding().withBody(this.visitRightPadded((JRightPadded<T>)c.getPadding().getBody(), JRightPadded.Location.CASE_BODY, newCase.getPadding().getBody()));
        return c.getPadding().withStatements(this.visitContainer((JContainer<J2>)c.getPadding().getStatements(), JContainer.Location.CASE, newCase.getPadding().getStatements()));
    }

    @Override
    public J visitCatch(J.Try.Catch catch_, @Nullable Object ctx) {
        if (catch_ == ctx || !(ctx instanceof J.Try.Catch)) {
            return catch_;
        }
        J.Try.Catch newCatch = (J.Try.Catch)ctx;
        J.Try.Catch c = catch_;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CATCH_PREFIX, newCatch.getPrefix()));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), newCatch.getMarkers()));
        c = c.withParameter((J.ControlParentheses)this.visitAndCast(c.getParameter(), newCatch.getParameter()));
        return c.withBody((J.Block)this.visitAndCast(c.getBody(), newCatch.getBody()));
    }

    @Override
    public J visitClassDeclaration(J.ClassDeclaration classDecl, @Nullable Object ctx) {
        if (classDecl == ctx || !(ctx instanceof J.ClassDeclaration)) {
            return classDecl;
        }
        J.ClassDeclaration newClassDecl = (J.ClassDeclaration)ctx;
        J.ClassDeclaration c = classDecl;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CLASS_DECLARATION_PREFIX, newClassDecl.getPrefix()));
        Statement temp = (Statement)this.visitStatement(c = c.withMarkers(this.visitMarkers(c.getMarkers(), newClassDecl.getMarkers())), newClassDecl);
        if (!(temp instanceof J.ClassDeclaration)) {
            return temp;
        }
        c = (J.ClassDeclaration)temp;
        c = c.withLeadingAnnotations(ListUtils.map(c.getLeadingAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newClassDecl.getLeadingAnnotations().get((int)index))));
        c = c.withModifiers(ListUtils.map(c.getModifiers(), (index, m) -> (J.Modifier)this.visitAndCast((Tree)m, newClassDecl.getModifiers().get((int)index))));
        c = c.getPadding().withKind(classDecl.getPadding().getKind().withAnnotations(ListUtils.map(classDecl.getPadding().getKind().getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newClassDecl.getPadding().getKind().getAnnotations().get((int)index)))));
        c = c.getPadding().withKind(c.getPadding().getKind().withPrefix(this.visitSpace(c.getPadding().getKind().getPrefix(), Space.Location.CLASS_KIND, newClassDecl.getPadding().getKind().getPrefix())));
        if ((c = c.withName((J.Identifier)this.visitAndCast(c.getName(), newClassDecl.getName()))).getPadding().getTypeParameters() != null && newClassDecl.getPadding().getTypeParameters() != null) {
            c = c.getPadding().withTypeParameters(this.visitContainer((JContainer<J2>)c.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, newClassDecl.getPadding().getTypeParameters()));
        }
        if (c.getPadding().getPrimaryConstructor() != null && newClassDecl.getPadding().getPrimaryConstructor() != null) {
            c = c.getPadding().withPrimaryConstructor(this.visitContainer((JContainer<J2>)c.getPadding().getPrimaryConstructor(), JContainer.Location.RECORD_STATE_VECTOR, newClassDecl.getPadding().getPrimaryConstructor()));
        }
        if (c.getPadding().getExtends() != null && newClassDecl.getPadding().getExtends() != null) {
            c = c.getPadding().withExtends(this.visitLeftPadded((JLeftPadded<T>)c.getPadding().getExtends(), JLeftPadded.Location.EXTENDS, newClassDecl.getPadding().getExtends()));
        }
        if ((c = c.getPadding().withExtends(this.visitTypeName(c.getPadding().getExtends(), newClassDecl.getPadding().getExtends()))).getPadding().getImplements() != null && newClassDecl.getPadding().getImplements() != null) {
            c = c.getPadding().withImplements(this.visitContainer((JContainer<J2>)c.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, newClassDecl.getPadding().getImplements()));
        }
        if (c.getPadding().getPermits() != null && newClassDecl.getPadding().getPermits() != null) {
            c = c.getPadding().withPermits(this.visitContainer((JContainer<J2>)c.getPadding().getPermits(), JContainer.Location.PERMITS, newClassDecl.getPadding().getPermits()));
        }
        c = c.getPadding().withImplements(this.visitTypeNames(c.getPadding().getImplements(), newClassDecl.getPadding().getImplements()));
        c = c.withBody((J.Block)this.visitAndCast(c.getBody(), newClassDecl.getBody()));
        return c.withType(this.visitType(c.getType(), newClassDecl.getType()));
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, @Nullable Object ctx) {
        if (cu == ctx || !(ctx instanceof J.CompilationUnit)) {
            return cu;
        }
        J.CompilationUnit newCu = (J.CompilationUnit)ctx;
        JavaSourceFile c = cu;
        c = ((J.CompilationUnit)c).withPrefix(this.visitSpace(((J.CompilationUnit)c).getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, newCu.getPrefix()));
        if (((J.CompilationUnit)(c = ((J.CompilationUnit)c).withMarkers(this.visitMarkers(((J.CompilationUnit)c).getMarkers(), newCu.getMarkers())))).getPadding().getPackageDeclaration() != null && newCu.getPadding().getPackageDeclaration() != null) {
            c = ((J.CompilationUnit)c).getPadding().withPackageDeclaration(this.visitRightPadded((JRightPadded<T>)((J.CompilationUnit)c).getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, newCu.getPadding().getPackageDeclaration()));
        }
        c = ((J.CompilationUnit)c).getPadding().withImports(ListUtils.map(((J.CompilationUnit)c).getPadding().getImports(), (index, t) -> this.visitRightPadded((JRightPadded<T>)((JRightPadded)t), JRightPadded.Location.IMPORT, newCu.getPadding().getImports().get((int)index))));
        c = ((J.CompilationUnit)c).withClasses(ListUtils.map(((J.CompilationUnit)c).getClasses(), (index, e) -> (J.ClassDeclaration)this.visitAndCast((Tree)e, newCu.getClasses().get((int)index))));
        return ((J.CompilationUnit)c).withEof(this.visitSpace(((J.CompilationUnit)c).getEof(), Space.Location.COMPILATION_UNIT_EOF, newCu.getEof()));
    }

    @Override
    public J visitContinue(J.Continue continueStatement, @Nullable Object ctx) {
        if (continueStatement == ctx || !(ctx instanceof J.Continue)) {
            return continueStatement;
        }
        J.Continue newContinueStatement = (J.Continue)ctx;
        J.Continue c = continueStatement;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CONTINUE_PREFIX, newContinueStatement.getPrefix()));
        Statement temp = (Statement)this.visitStatement(c = c.withMarkers(this.visitMarkers(c.getMarkers(), newContinueStatement.getMarkers())), newContinueStatement);
        if (!(temp instanceof J.Continue)) {
            return temp;
        }
        c = (J.Continue)temp;
        return c.withLabel((J.Identifier)this.visitAndCast(c.getLabel(), newContinueStatement.getLabel()));
    }

    @Override
    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, @Nullable Object ctx) {
        J.ControlParentheses newControlParens = (J.ControlParentheses)ctx;
        if (controlParens == newControlParens) {
            return controlParens;
        }
        J.ControlParentheses cp = controlParens;
        Expression temp = (Expression)this.visitExpression(cp = cp.withPrefix(this.visitSpace(cp.getPrefix(), Space.Location.CONTROL_PARENTHESES_PREFIX, newControlParens.getPrefix())), newControlParens);
        if (!(temp instanceof J.ControlParentheses)) {
            return temp;
        }
        cp = (J.ControlParentheses)temp;
        cp = cp.getPadding().withTree(this.visitRightPadded((JRightPadded<T>)cp.getPadding().getTree(), JRightPadded.Location.PARENTHESES, newControlParens.getPadding().getTree()));
        return cp.withMarkers(this.visitMarkers(cp.getMarkers(), newControlParens.getMarkers()));
    }

    @Override
    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, @Nullable Object ctx) {
        if (doWhileLoop == ctx || !(ctx instanceof J.DoWhileLoop)) {
            return doWhileLoop;
        }
        J.DoWhileLoop newDoWhileLoop = (J.DoWhileLoop)ctx;
        J.DoWhileLoop d = doWhileLoop;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), Space.Location.DO_WHILE_PREFIX, newDoWhileLoop.getPrefix()));
        Statement temp = (Statement)this.visitStatement(d = d.withMarkers(this.visitMarkers(d.getMarkers(), newDoWhileLoop.getMarkers())), newDoWhileLoop);
        if (!(temp instanceof J.DoWhileLoop)) {
            return temp;
        }
        d = (J.DoWhileLoop)temp;
        d = d.getPadding().withWhileCondition(this.visitLeftPadded((JLeftPadded<T>)d.getPadding().getWhileCondition(), JLeftPadded.Location.WHILE_CONDITION, newDoWhileLoop.getPadding().getWhileCondition()));
        return d.getPadding().withBody(this.visitRightPadded((JRightPadded<T>)d.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, newDoWhileLoop.getPadding().getBody()));
    }

    @Override
    public J visitEmpty(J.Empty empty, @Nullable Object ctx) {
        if (empty == ctx || !(ctx instanceof J.Empty)) {
            return empty;
        }
        J.Empty newEmpty = (J.Empty)ctx;
        J.Empty e = empty;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.EMPTY_PREFIX, newEmpty.getPrefix()));
        Statement temp = (Statement)this.visitStatement(e = e.withMarkers(this.visitMarkers(e.getMarkers(), newEmpty.getMarkers())), newEmpty);
        if (!(temp instanceof J.Empty)) {
            return temp;
        }
        return this.visitExpression((J.Empty)temp, newEmpty);
    }

    @Override
    public J visitEnumValue(J.EnumValue enum_, @Nullable Object ctx) {
        if (enum_ == ctx || !(ctx instanceof J.EnumValue)) {
            return enum_;
        }
        J.EnumValue newEnum = (J.EnumValue)ctx;
        J.EnumValue e = enum_;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ENUM_VALUE_PREFIX, newEnum.getPrefix()));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), newEnum.getMarkers()));
        e = e.withAnnotations(ListUtils.map(e.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newEnum.getAnnotations().get((int)index))));
        e = e.withName((J.Identifier)this.visitAndCast(e.getName(), newEnum.getName()));
        return e.withInitializer((J.NewClass)this.visitAndCast(e.getInitializer(), newEnum.getInitializer()));
    }

    @Override
    public J visitEnumValueSet(J.EnumValueSet enums, @Nullable Object ctx) {
        if (enums == ctx || !(ctx instanceof J.EnumValueSet)) {
            return enums;
        }
        J.EnumValueSet newEnums = (J.EnumValueSet)ctx;
        J.EnumValueSet e = enums;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ENUM_VALUE_SET_PREFIX, newEnums.getPrefix()));
        Statement temp = (Statement)this.visitStatement(e = e.withMarkers(this.visitMarkers(e.getMarkers(), newEnums.getMarkers())), newEnums);
        if (!(temp instanceof J.EnumValueSet)) {
            return temp;
        }
        e = (J.EnumValueSet)temp;
        return e.getPadding().withEnums(ListUtils.map(e.getPadding().getEnums(), (index, t) -> this.visitRightPadded((JRightPadded<T>)((JRightPadded)t), JRightPadded.Location.ENUM_VALUE, newEnums.getPadding().getEnums().get((int)index))));
    }

    @Override
    public J visitFieldAccess(J.FieldAccess fieldAccess, @Nullable Object ctx) {
        if (fieldAccess == ctx || !(ctx instanceof J.FieldAccess)) {
            return fieldAccess;
        }
        J.FieldAccess newFieldAccess = (J.FieldAccess)ctx;
        J.FieldAccess f = fieldAccess;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FIELD_ACCESS_PREFIX, newFieldAccess.getPrefix()));
        f = f.withMarkers(this.visitMarkers(f.getMarkers(), newFieldAccess.getMarkers()));
        Expression temp = (Expression)this.visitExpression(f = this.visitTypeName((N)f, (Object)newFieldAccess), newFieldAccess);
        if (!(temp instanceof J.FieldAccess)) {
            return temp;
        }
        f = (J.FieldAccess)temp;
        Statement tempStat = (Statement)this.visitStatement(f, newFieldAccess);
        if (!(tempStat instanceof J.FieldAccess)) {
            return tempStat;
        }
        f = (J.FieldAccess)tempStat;
        f = f.withTarget((Expression)this.visitAndCast(f.getTarget(), newFieldAccess.getTarget()));
        f = f.getPadding().withName(this.visitLeftPadded((JLeftPadded<T>)f.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, newFieldAccess.getPadding().getName()));
        return f.withType(this.visitType(f.getType(), newFieldAccess.getType()));
    }

    @Override
    public J visitForEachLoop(J.ForEachLoop forLoop, @Nullable Object ctx) {
        if (forLoop == ctx || !(ctx instanceof J.ForEachLoop)) {
            return forLoop;
        }
        J.ForEachLoop newForLoop = (J.ForEachLoop)ctx;
        J.ForEachLoop f = forLoop;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FOR_EACH_LOOP_PREFIX, newForLoop.getPrefix()));
        Statement temp = (Statement)this.visitStatement(f = f.withMarkers(this.visitMarkers(f.getMarkers(), newForLoop.getMarkers())), newForLoop);
        if (!(temp instanceof J.ForEachLoop)) {
            return temp;
        }
        f = (J.ForEachLoop)temp;
        f = f.withControl((J.ForEachLoop.Control)this.visitAndCast(f.getControl(), newForLoop.getControl()));
        return f.getPadding().withBody(this.visitRightPadded((JRightPadded<T>)f.getPadding().getBody(), JRightPadded.Location.FOR_BODY, newForLoop.getPadding().getBody()));
    }

    @Override
    public J visitForEachControl(J.ForEachLoop.Control control, @Nullable Object ctx) {
        if (control == ctx || !(ctx instanceof J.ForEachLoop.Control)) {
            return control;
        }
        J.ForEachLoop.Control newControl = (J.ForEachLoop.Control)ctx;
        J.ForEachLoop.Control c = control;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, newControl.getPrefix()));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), newControl.getMarkers()));
        c = c.getPadding().withVariable(this.visitRightPadded((JRightPadded<T>)c.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, newControl.getPadding().getVariable()));
        return c.getPadding().withIterable(this.visitRightPadded((JRightPadded<T>)c.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, newControl.getPadding().getIterable()));
    }

    @Override
    public J visitForLoop(J.ForLoop forLoop, @Nullable Object ctx) {
        if (forLoop == ctx || !(ctx instanceof J.ForLoop)) {
            return forLoop;
        }
        J.ForLoop newForLoop = (J.ForLoop)ctx;
        J.ForLoop f = forLoop;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FOR_PREFIX, newForLoop.getPrefix()));
        Statement temp = (Statement)this.visitStatement(f = f.withMarkers(this.visitMarkers(f.getMarkers(), newForLoop.getMarkers())), newForLoop);
        if (!(temp instanceof J.ForLoop)) {
            return temp;
        }
        f = (J.ForLoop)temp;
        f = f.withControl((J.ForLoop.Control)this.visitAndCast(f.getControl(), newForLoop.getControl()));
        return f.getPadding().withBody(this.visitRightPadded((JRightPadded<T>)f.getPadding().getBody(), JRightPadded.Location.FOR_BODY, newForLoop.getPadding().getBody()));
    }

    @Override
    public J visitForControl(J.ForLoop.Control control, @Nullable Object ctx) {
        if (control == ctx || !(ctx instanceof J.ForLoop.Control)) {
            return control;
        }
        J.ForLoop.Control newControl = (J.ForLoop.Control)ctx;
        J.ForLoop.Control c = control;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.FOR_CONTROL_PREFIX, newControl.getPrefix()));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), newControl.getMarkers()));
        c = c.getPadding().withInit(ListUtils.map(c.getPadding().getInit(), (index, t) -> this.visitRightPadded((JRightPadded<T>)((JRightPadded)t), JRightPadded.Location.FOR_INIT, newControl.getPadding().getInit().get((int)index))));
        c = c.getPadding().withCondition(this.visitRightPadded((JRightPadded<T>)c.getPadding().getCondition(), JRightPadded.Location.FOR_CONDITION, newControl.getPadding().getCondition()));
        return c.getPadding().withUpdate(ListUtils.map(c.getPadding().getUpdate(), (index, t) -> this.visitRightPadded((JRightPadded<T>)((JRightPadded)t), JRightPadded.Location.FOR_UPDATE, newControl.getPadding().getUpdate().get((int)index))));
    }

    @Override
    public J visitParenthesizedTypeTree(J.ParenthesizedTypeTree parTree, @Nullable Object ctx) {
        J temp;
        if (parTree == ctx || !(ctx instanceof J.ParenthesizedTypeTree)) {
            return parTree;
        }
        J.ParenthesizedTypeTree newParTree = (J.ParenthesizedTypeTree)ctx;
        J.ParenthesizedTypeTree t = parTree;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.PARENTHESES_PREFIX, newParTree.getPrefix()));
        if ((t = t.withMarkers(this.visitMarkers(t.getMarkers(), newParTree.getMarkers()))).getAnnotations() != null && !t.getAnnotations().isEmpty()) {
            t = t.withAnnotations(ListUtils.map(t.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newParTree.getAnnotations().get((int)index))));
        }
        if (!((temp = this.visitParentheses((J.Parentheses<T>)t.getParenthesizedType(), newParTree.getParenthesizedType())) instanceof J.Parentheses)) {
            return temp;
        }
        return t.withParenthesizedType((J.Parentheses)temp);
    }

    @Override
    public J visitIdentifier(J.Identifier ident, @Nullable Object ctx) {
        if (ident == ctx || !(ctx instanceof J.Identifier)) {
            return ident;
        }
        J.Identifier newIdent = (J.Identifier)ctx;
        J.Identifier i = ident;
        if (i.getAnnotations() != null && !i.getAnnotations().isEmpty()) {
            i = i.withAnnotations(ListUtils.map(i.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newIdent.getAnnotations().get((int)index))));
        }
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IDENTIFIER_PREFIX, newIdent.getPrefix()));
        Expression temp = (Expression)this.visitExpression(i = i.withMarkers(this.visitMarkers(i.getMarkers(), newIdent.getMarkers())), newIdent);
        if (!(temp instanceof J.Identifier)) {
            return temp;
        }
        i = (J.Identifier)temp;
        i = i.withType(this.visitType(i.getType(), newIdent.getType()));
        return i.withFieldType((JavaType.Variable)this.visitType(i.getFieldType(), newIdent.getFieldType()));
    }

    @Override
    public J visitElse(J.If.Else else_, @Nullable Object ctx) {
        if (else_ == ctx || !(ctx instanceof J.If.Else)) {
            return else_;
        }
        J.If.Else newElse = (J.If.Else)ctx;
        J.If.Else e = else_;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ELSE_PREFIX, newElse.getPrefix()));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), newElse.getMarkers()));
        return e.getPadding().withBody(this.visitRightPadded((JRightPadded<T>)e.getPadding().getBody(), JRightPadded.Location.IF_ELSE, newElse.getPadding().getBody()));
    }

    @Override
    public J visitIf(J.If iff, @Nullable Object ctx) {
        if (iff == ctx || !(ctx instanceof J.If)) {
            return iff;
        }
        J.If newIff = (J.If)ctx;
        J.If i = iff;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IF_PREFIX, newIff.getPrefix()));
        Statement temp = (Statement)this.visitStatement(i = i.withMarkers(this.visitMarkers(i.getMarkers(), newIff.getMarkers())), newIff);
        if (!(temp instanceof J.If)) {
            return temp;
        }
        i = (J.If)temp;
        i = i.withIfCondition((J.ControlParentheses)this.visitAndCast(i.getIfCondition(), newIff.getIfCondition()));
        i = i.getPadding().withThenPart(this.visitRightPadded((JRightPadded<T>)i.getPadding().getThenPart(), JRightPadded.Location.IF_THEN, newIff.getPadding().getThenPart()));
        return i.withElsePart((J.If.Else)this.visitAndCast(i.getElsePart(), newIff.getElsePart()));
    }

    @Override
    public J visitImport(J.Import import_, @Nullable Object ctx) {
        if (import_ == ctx || !(ctx instanceof J.Import)) {
            return import_;
        }
        J.Import newImport = (J.Import)ctx;
        J.Import i = import_;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IMPORT_PREFIX, newImport.getPrefix()));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), newImport.getMarkers()));
        i = i.getPadding().withStatic(this.visitLeftPadded((JLeftPadded<T>)i.getPadding().getStatic(), JLeftPadded.Location.STATIC_IMPORT, newImport.getPadding().getStatic()));
        i = i.withQualid((J.FieldAccess)this.visitAndCast(i.getQualid(), newImport.getQualid()));
        return i.getPadding().withAlias(this.visitLeftPadded((JLeftPadded<T>)i.getPadding().getAlias(), JLeftPadded.Location.IMPORT_ALIAS_PREFIX, newImport.getPadding().getAlias()));
    }

    @Override
    public J visitInstanceOf(J.InstanceOf instanceOf, @Nullable Object ctx) {
        if (instanceOf == ctx || !(ctx instanceof J.InstanceOf)) {
            return instanceOf;
        }
        J.InstanceOf newInstanceOf = (J.InstanceOf)ctx;
        J.InstanceOf i = instanceOf;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.INSTANCEOF_PREFIX, newInstanceOf.getPrefix()));
        Expression temp = (Expression)this.visitExpression(i = i.withMarkers(this.visitMarkers(i.getMarkers(), newInstanceOf.getMarkers())), newInstanceOf);
        if (!(temp instanceof J.InstanceOf)) {
            return temp;
        }
        i = (J.InstanceOf)temp;
        i = i.getPadding().withExpression(this.visitRightPadded((JRightPadded<T>)i.getPadding().getExpression(), JRightPadded.Location.INSTANCEOF, newInstanceOf.getPadding().getExpression()));
        i = i.withClazz((J)this.visitAndCast(i.getClazz(), newInstanceOf.getClazz()));
        i = i.withPattern((J)this.visitAndCast(i.getPattern(), newInstanceOf.getPattern()));
        return i.withType(this.visitType(i.getType(), newInstanceOf.getType()));
    }

    @Override
    public J visitDeconstructionPattern(J.DeconstructionPattern deconstructionPattern, @Nullable Object ctx) {
        if (deconstructionPattern == ctx || !(ctx instanceof J.DeconstructionPattern)) {
            return deconstructionPattern;
        }
        J.DeconstructionPattern newDeconstructionPattern = (J.DeconstructionPattern)ctx;
        J.DeconstructionPattern d = deconstructionPattern;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), Space.Location.DECONSTRUCTION_PATTERN_PREFIX, newDeconstructionPattern.getPrefix()));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), newDeconstructionPattern.getMarkers()));
        d = d.withDeconstructor((Expression)this.visitAndCast(d.getDeconstructor(), newDeconstructionPattern.getDeconstructor()));
        d = d.getPadding().withNested(this.visitContainer((JContainer<J2>)d.getPadding().getNested(), JContainer.Location.DECONSTRUCTION_PATTERN_NESTED, newDeconstructionPattern.getPadding().getNested()));
        return d.withType(this.visitType(d.getType(), newDeconstructionPattern.getType()));
    }

    @Override
    public J visitIntersectionType(J.IntersectionType intersectionType, @Nullable Object ctx) {
        if (intersectionType == ctx || !(ctx instanceof J.IntersectionType)) {
            return intersectionType;
        }
        J.IntersectionType newIntersectionType = (J.IntersectionType)ctx;
        J.IntersectionType i = intersectionType;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.INTERSECTION_TYPE_PREFIX, newIntersectionType.getPrefix()));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), newIntersectionType.getMarkers()));
        i = i.getPadding().withBounds(this.visitContainer((JContainer<J2>)i.getPadding().getBounds(), JContainer.Location.TYPE_BOUNDS, newIntersectionType.getPadding().getBounds()));
        return i.withType(this.visitType(i.getType(), newIntersectionType.getType()));
    }

    @Override
    public J visitLabel(J.Label label, @Nullable Object ctx) {
        if (label == ctx || !(ctx instanceof J.Label)) {
            return label;
        }
        J.Label newLabel = (J.Label)ctx;
        J.Label l = label;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LABEL_PREFIX, newLabel.getPrefix()));
        Statement temp = (Statement)this.visitStatement(l = l.withMarkers(this.visitMarkers(l.getMarkers(), newLabel.getMarkers())), newLabel);
        if (!(temp instanceof J.Label)) {
            return temp;
        }
        l = (J.Label)temp;
        l = l.getPadding().withLabel(this.visitRightPadded((JRightPadded<T>)l.getPadding().getLabel(), JRightPadded.Location.LABEL, newLabel.getPadding().getLabel()));
        return l.withStatement((Statement)this.visitAndCast(l.getStatement(), newLabel.getStatement()));
    }

    @Override
    public J visitLambda(J.Lambda lambda, @Nullable Object ctx) {
        if (lambda == ctx || !(ctx instanceof J.Lambda)) {
            return lambda;
        }
        J.Lambda newLambda = (J.Lambda)ctx;
        J.Lambda l = lambda;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LAMBDA_PREFIX, newLambda.getPrefix()));
        Expression temp = (Expression)this.visitExpression(l = l.withMarkers(this.visitMarkers(l.getMarkers(), newLambda.getMarkers())), newLambda);
        if (!(temp instanceof J.Lambda)) {
            return temp;
        }
        l = (J.Lambda)temp;
        l = l.withParameters((J.Lambda.Parameters)this.visitAndCast(l.getParameters(), newLambda.getParameters()));
        l = l.withArrow(this.visitSpace(l.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, newLambda.getArrow()));
        l = l.withBody((J)this.visitAndCast(l.getBody(), newLambda.getBody()));
        return l.withType(this.visitType(l.getType(), newLambda.getType()));
    }

    @Override
    public J visitLambdaParameters(J.Lambda.Parameters parameters, @Nullable Object ctx) {
        if (parameters == ctx || !(ctx instanceof J.Lambda.Parameters)) {
            return parameters;
        }
        J.Lambda.Parameters newParameters = (J.Lambda.Parameters)ctx;
        J.Lambda.Parameters params = parameters;
        params = params.withPrefix(this.visitSpace(params.getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, newParameters.getPrefix()));
        params = params.withMarkers(this.visitMarkers(params.getMarkers(), newParameters.getMarkers()));
        return params.getPadding().withParameters(ListUtils.map(params.getPadding().getParameters(), (index, param) -> this.visitRightPadded((JRightPadded<T>)((JRightPadded)param), JRightPadded.Location.LAMBDA_PARAM, newParameters.getPadding().getParameters().get((int)index))));
    }

    @Override
    public J visitLiteral(J.Literal literal, @Nullable Object ctx) {
        if (literal == ctx || !(ctx instanceof J.Literal)) {
            return literal;
        }
        J.Literal newLiteral = (J.Literal)ctx;
        J.Literal l = literal;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LITERAL_PREFIX, newLiteral.getPrefix()));
        Expression temp = (Expression)this.visitExpression(l = l.withMarkers(this.visitMarkers(l.getMarkers(), newLiteral.getMarkers())), newLiteral);
        if (!(temp instanceof J.Literal)) {
            return temp;
        }
        l = (J.Literal)temp;
        return l.withType(this.visitType(l.getType(), newLiteral.getType()));
    }

    @Override
    public J visitMemberReference(J.MemberReference memberRef, @Nullable Object ctx) {
        if (memberRef == ctx || !(ctx instanceof J.MemberReference)) {
            return memberRef;
        }
        J.MemberReference newMemberRef = (J.MemberReference)ctx;
        J.MemberReference m = memberRef;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.MEMBER_REFERENCE_PREFIX, newMemberRef.getPrefix()));
        Expression temp = (Expression)this.visitExpression(m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMemberRef.getMarkers())), newMemberRef);
        if (!(temp instanceof J.MemberReference)) {
            return temp;
        }
        m = (J.MemberReference)temp;
        if ((m = m.getPadding().withContaining(this.visitRightPadded((JRightPadded<T>)m.getPadding().getContaining(), JRightPadded.Location.MEMBER_REFERENCE_CONTAINING, newMemberRef.getPadding().getContaining()))).getPadding().getTypeParameters() != null && newMemberRef.getPadding().getTypeParameters() != null) {
            m = m.getPadding().withTypeParameters(this.visitContainer((JContainer<J2>)m.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, newMemberRef.getPadding().getTypeParameters()));
        }
        m = m.getPadding().withReference(this.visitLeftPadded((JLeftPadded<T>)m.getPadding().getReference(), JLeftPadded.Location.MEMBER_REFERENCE_NAME, newMemberRef.getPadding().getReference()));
        m = m.withType(this.visitType(m.getType(), newMemberRef.getType()));
        m = m.withMethodType((JavaType.Method)this.visitType(m.getMethodType(), newMemberRef.getMethodType()));
        return m.withVariableType((JavaType.Variable)this.visitType(m.getVariableType(), newMemberRef.getVariableType()));
    }

    @Override
    public J visitMethodDeclaration(J.MethodDeclaration method, @Nullable Object ctx) {
        if (method == ctx || !(ctx instanceof J.MethodDeclaration)) {
            return method;
        }
        J.MethodDeclaration newMethod = (J.MethodDeclaration)ctx;
        J.MethodDeclaration m = method;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.METHOD_DECLARATION_PREFIX, newMethod.getPrefix()));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMethod.getMarkers())), newMethod);
        if (!(temp instanceof J.MethodDeclaration)) {
            return temp;
        }
        m = (J.MethodDeclaration)temp;
        m = m.withLeadingAnnotations(ListUtils.map(m.getLeadingAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newMethod.getLeadingAnnotations().get((int)index))));
        m = m.withModifiers(ListUtils.map(m.getModifiers(), (index, e) -> (J.Modifier)this.visitAndCast((Tree)e, newMethod.getModifiers().get((int)index))));
        m = m.getAnnotations().withTypeParameters((J.TypeParameters)this.visit(m.getAnnotations().getTypeParameters(), newMethod.getAnnotations().getTypeParameters()));
        m = m.withReturnTypeExpression((m = m.withReturnTypeExpression((TypeTree)this.visitAndCast(m.getReturnTypeExpression(), newMethod.getReturnTypeExpression()))).getReturnTypeExpression() == null ? null : this.visitTypeName((N)m.getReturnTypeExpression(), (Object)newMethod.getReturnTypeExpression()));
        m = m.getAnnotations().withName(m.getAnnotations().getName().withAnnotations(ListUtils.map(m.getAnnotations().getName().getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newMethod.getAnnotations().getName().getAnnotations().get((int)index)))));
        m = m.withName((J.Identifier)this.visitNonNull(m.getName(), newMethod.getName()));
        if ((m = m.getPadding().withParameters(this.visitContainer((JContainer<J2>)m.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, newMethod.getPadding().getParameters()))).getPadding().getThrows() != null) {
            m = m.getPadding().withThrows(this.visitContainer((JContainer<J2>)m.getPadding().getThrows(), JContainer.Location.THROWS, newMethod.getPadding().getThrows()));
        }
        m = m.getPadding().withThrows(this.visitTypeNames(m.getPadding().getThrows(), newMethod.getPadding().getThrows()));
        if ((m = m.withBody((J.Block)this.visitAndCast(m.getBody(), newMethod.getBody()))).getPadding().getDefaultValue() != null) {
            m = m.getPadding().withDefaultValue(this.visitLeftPadded((JLeftPadded<T>)m.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, newMethod.getPadding().getDefaultValue()));
        }
        return m.withMethodType((JavaType.Method)this.visitType(m.getMethodType(), newMethod.getMethodType()));
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, @Nullable Object ctx) {
        if (method == ctx || !(ctx instanceof J.MethodInvocation)) {
            return method;
        }
        J.MethodInvocation newMethod = (J.MethodInvocation)ctx;
        J.MethodInvocation m = method;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.METHOD_INVOCATION_PREFIX, newMethod.getPrefix()));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMethod.getMarkers())), newMethod);
        if (!(temp instanceof J.MethodInvocation)) {
            return temp;
        }
        m = (J.MethodInvocation)temp;
        Expression temp2 = (Expression)this.visitExpression(m, newMethod);
        if (!(temp2 instanceof J.MethodInvocation)) {
            return temp2;
        }
        m = (J.MethodInvocation)temp2;
        if (m.getPadding().getSelect() != null && m.getPadding().getSelect().getElement() instanceof NameTree && method.getMethodType() != null && method.getMethodType().hasFlags(Flag.Static)) {
            m = m.getPadding().withSelect(this.visitTypeName(m.getPadding().getSelect(), newMethod.getPadding().getSelect()));
        }
        if (m.getPadding().getSelect() != null) {
            m = m.getPadding().withSelect(this.visitRightPadded((JRightPadded<T>)m.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, newMethod.getPadding().getSelect()));
        }
        if (m.getPadding().getTypeParameters() != null) {
            m = m.getPadding().withTypeParameters(this.visitContainer((JContainer<J2>)m.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, newMethod.getPadding().getTypeParameters()));
        }
        m = m.getPadding().withTypeParameters(this.visitTypeNames(m.getPadding().getTypeParameters(), newMethod.getPadding().getTypeParameters()));
        m = m.withName((J.Identifier)this.visitNonNull(m.getName(), newMethod.getName()));
        m = m.getPadding().withArguments(this.visitContainer((JContainer<J2>)m.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, newMethod.getPadding().getArguments()));
        return m.withMethodType((JavaType.Method)this.visitType(m.getMethodType(), newMethod.getMethodType()));
    }

    @Override
    public J visitModifier(J.Modifier modifer, @Nullable Object ctx) {
        if (modifer == ctx || !(ctx instanceof J.Modifier)) {
            return modifer;
        }
        J.Modifier newModifer = (J.Modifier)ctx;
        J.Modifier m = modifer;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.MODIFIER_PREFIX, newModifer.getPrefix()));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), newModifer.getMarkers()));
        return m.withAnnotations(ListUtils.map(m.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newModifer.getAnnotations().get((int)index))));
    }

    @Override
    public J visitMultiCatch(J.MultiCatch multiCatch, @Nullable Object ctx) {
        if (multiCatch == ctx || !(ctx instanceof J.MultiCatch)) {
            return multiCatch;
        }
        J.MultiCatch newMultiCatch = (J.MultiCatch)ctx;
        J.MultiCatch m = multiCatch;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.MULTI_CATCH_PREFIX, newMultiCatch.getPrefix()));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMultiCatch.getMarkers()));
        return m.getPadding().withAlternatives(ListUtils.map(m.getPadding().getAlternatives(), (index, t) -> this.visitTypeName(this.visitRightPadded((JRightPadded<T>)((JRightPadded)t), JRightPadded.Location.CATCH_ALTERNATIVE, newMultiCatch.getPadding().getAlternatives().get((int)index)), newMultiCatch.getPadding().getAlternatives().get((int)index))));
    }

    @Override
    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, @Nullable Object ctx) {
        if (multiVariable == ctx || !(ctx instanceof J.VariableDeclarations)) {
            return multiVariable;
        }
        J.VariableDeclarations newMultiVariable = (J.VariableDeclarations)ctx;
        J.VariableDeclarations m = multiVariable;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.VARIABLE_DECLARATIONS_PREFIX, newMultiVariable.getPrefix()));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), newMultiVariable.getMarkers())), newMultiVariable);
        if (!(temp instanceof J.VariableDeclarations)) {
            return temp;
        }
        m = (J.VariableDeclarations)temp;
        m = m.withLeadingAnnotations(ListUtils.map(m.getLeadingAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newMultiVariable.getLeadingAnnotations().get((int)index))));
        m = m.withModifiers(Objects.requireNonNull(ListUtils.map(m.getModifiers(), (index, e) -> (J.Modifier)this.visitAndCast((Tree)e, newMultiVariable.getModifiers().get((int)index)))));
        m = m.withTypeExpression((m = m.withTypeExpression((TypeTree)this.visitAndCast(m.getTypeExpression(), newMultiVariable.getTypeExpression()))).getTypeExpression() == null ? null : this.visitTypeName((N)m.getTypeExpression(), (Object)newMultiVariable.getTypeExpression()));
        m = m.withVarargs(m.getVarargs() == null ? null : this.visitSpace(m.getVarargs(), Space.Location.VARARGS, newMultiVariable.getVarargs()));
        return m.getPadding().withVariables(ListUtils.map(m.getPadding().getVariables(), (index, t) -> this.visitRightPadded((JRightPadded<T>)((JRightPadded)t), JRightPadded.Location.NAMED_VARIABLE, newMultiVariable.getPadding().getVariables().get((int)index))));
    }

    @Override
    public J visitNewArray(J.NewArray newArray, @Nullable Object ctx) {
        if (newArray == ctx || !(ctx instanceof J.NewArray)) {
            return newArray;
        }
        J.NewArray newNewArray = (J.NewArray)ctx;
        J.NewArray n = newArray;
        n = n.withPrefix(this.visitSpace(n.getPrefix(), Space.Location.NEW_ARRAY_PREFIX, newNewArray.getPrefix()));
        Expression temp = (Expression)this.visitExpression(n = n.withMarkers(this.visitMarkers(n.getMarkers(), newNewArray.getMarkers())), newNewArray);
        if (!(temp instanceof J.NewArray)) {
            return temp;
        }
        n = (J.NewArray)temp;
        n = n.withTypeExpression((n = n.withTypeExpression((TypeTree)this.visitAndCast(n.getTypeExpression(), newNewArray.getTypeExpression()))).getTypeExpression() == null ? null : this.visitTypeName((N)n.getTypeExpression(), (Object)newNewArray.getTypeExpression()));
        if ((n = n.withDimensions(ListUtils.map(n.getDimensions(), (index, d) -> (J.ArrayDimension)this.visitAndCast((Tree)d, newNewArray.getDimensions().get((int)index))))).getPadding().getInitializer() != null) {
            n = n.getPadding().withInitializer(this.visitContainer((JContainer<J2>)n.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, newNewArray.getPadding().getInitializer()));
        }
        return n.withType(this.visitType(n.getType(), newNewArray.getType()));
    }

    @Override
    public J visitNewClass(J.NewClass newClass, @Nullable Object ctx) {
        Statement temp;
        if (newClass == ctx || !(ctx instanceof J.NewClass)) {
            return newClass;
        }
        J.NewClass newNewClass = (J.NewClass)ctx;
        J.NewClass n = newClass;
        n = n.withPrefix(this.visitSpace(n.getPrefix(), Space.Location.NEW_CLASS_PREFIX, newNewClass.getPrefix()));
        if ((n = n.withMarkers(this.visitMarkers(n.getMarkers(), newNewClass.getMarkers()))).getPadding().getEnclosing() != null) {
            n = n.getPadding().withEnclosing(this.visitRightPadded((JRightPadded<T>)n.getPadding().getEnclosing(), JRightPadded.Location.NEW_CLASS_ENCLOSING, newNewClass.getPadding().getEnclosing()));
        }
        if (!((temp = (Statement)this.visitStatement(n, newNewClass)) instanceof J.NewClass)) {
            return temp;
        }
        n = (J.NewClass)temp;
        Expression temp2 = (Expression)this.visitExpression(n, newNewClass);
        if (!(temp2 instanceof J.NewClass)) {
            return temp2;
        }
        n = (J.NewClass)temp2;
        n = n.withNew(this.visitSpace(n.getNew(), Space.Location.NEW_PREFIX, newNewClass.getNew()));
        n = n.withClazz((n = n.withClazz((TypeTree)this.visitAndCast(n.getClazz(), newNewClass.getClazz()))).getClazz() == null ? null : this.visitTypeName((N)n.getClazz(), (Object)newNewClass.getClazz()));
        n = n.getPadding().withArguments(this.visitContainer((JContainer<J2>)n.getPadding().getArguments(), JContainer.Location.NEW_CLASS_ARGUMENTS, newNewClass.getPadding().getArguments()));
        n = n.withBody((J.Block)this.visitAndCast(n.getBody(), newNewClass.getBody()));
        return n.withConstructorType((JavaType.Method)this.visitType(n.getConstructorType(), newNewClass.getConstructorType()));
    }

    @Override
    public J visitNullableType(J.NullableType nullableType, @Nullable Object ctx) {
        if (nullableType == ctx || !(ctx instanceof J.NullableType)) {
            return nullableType;
        }
        J.NullableType newNullableType = (J.NullableType)ctx;
        J.NullableType nt = nullableType;
        nt = nt.withPrefix(this.visitSpace(nt.getPrefix(), Space.Location.NULLABLE_TYPE_PREFIX, newNullableType.getPrefix()));
        nt = nt.withMarkers(this.visitMarkers(nt.getMarkers(), newNullableType.getMarkers()));
        Expression temp = (Expression)this.visitExpression(nt = nt.withAnnotations(ListUtils.map(nt.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newNullableType.getAnnotations().get((int)index)))), newNullableType);
        if (!(temp instanceof J.NullableType)) {
            return temp;
        }
        nt = (J.NullableType)temp;
        nt = nt.getPadding().withTypeTree(this.visitRightPadded((JRightPadded<T>)nt.getPadding().getTypeTree(), JRightPadded.Location.NULLABLE, newNullableType.getPadding().getTypeTree()));
        return nt.withType(this.visitType(nt.getType(), newNullableType.getType()));
    }

    @Override
    public J visitPackage(J.Package pkg, @Nullable Object ctx) {
        if (pkg == ctx || !(ctx instanceof J.Package)) {
            return pkg;
        }
        J.Package newPkg = (J.Package)ctx;
        J.Package pa = pkg;
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), Space.Location.PACKAGE_PREFIX, newPkg.getPrefix()));
        pa = pa.withMarkers(this.visitMarkers(pa.getMarkers(), newPkg.getMarkers()));
        pa = pa.withExpression((Expression)this.visitAndCast(pa.getExpression(), newPkg.getExpression()));
        return pa.withAnnotations(ListUtils.map(pa.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newPkg.getAnnotations().get((int)index))));
    }

    @Override
    public J visitParameterizedType(J.ParameterizedType type, @Nullable Object ctx) {
        if (type == ctx || !(ctx instanceof J.ParameterizedType)) {
            return type;
        }
        J.ParameterizedType newType = (J.ParameterizedType)ctx;
        J.ParameterizedType pt = type;
        pt = pt.withPrefix(this.visitSpace(pt.getPrefix(), Space.Location.PARAMETERIZED_TYPE_PREFIX, newType.getPrefix()));
        Expression temp = (Expression)this.visitExpression(pt = pt.withMarkers(this.visitMarkers(pt.getMarkers(), newType.getMarkers())), newType);
        if (!(temp instanceof J.ParameterizedType)) {
            return temp;
        }
        pt = (J.ParameterizedType)temp;
        if ((pt = pt.withClazz((NameTree)this.visitAndCast(pt.getClazz(), newType.getClazz()))).getPadding().getTypeParameters() != null) {
            pt = pt.getPadding().withTypeParameters(this.visitContainer((JContainer<J2>)pt.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, newType.getPadding().getTypeParameters()));
        }
        pt = pt.getPadding().withTypeParameters(this.visitTypeNames(pt.getPadding().getTypeParameters(), newType.getPadding().getTypeParameters()));
        return pt.withType(this.visitType(pt.getType(), newType.getType()));
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, @Nullable Object ctx) {
        J.Parentheses newParens = (J.Parentheses)ctx;
        if (parens == newParens) {
            return parens;
        }
        J pa = parens;
        pa = ((J.Parentheses)pa).withPrefix(this.visitSpace(((J.Parentheses)pa).getPrefix(), Space.Location.PARENTHESES_PREFIX, newParens.getPrefix()));
        Expression temp = (Expression)this.visitExpression((Expression)(pa = ((J.Parentheses)pa).withMarkers(this.visitMarkers(((J.Parentheses)pa).getMarkers(), newParens.getMarkers()))), newParens);
        if (!(temp instanceof J.Parentheses)) {
            return temp;
        }
        pa = (J.Parentheses)temp;
        return ((J.Parentheses)pa).getPadding().withTree(this.visitRightPadded((JRightPadded<T>)((J.Parentheses)pa).getPadding().getTree(), JRightPadded.Location.PARENTHESES, newParens.getPadding().getTree()));
    }

    @Override
    public J visitPrimitive(J.Primitive primitive, @Nullable Object ctx) {
        if (primitive == ctx || !(ctx instanceof J.Primitive)) {
            return primitive;
        }
        J.Primitive newPrimitive = (J.Primitive)ctx;
        J.Primitive pr = primitive;
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), Space.Location.PRIMITIVE_PREFIX, newPrimitive.getPrefix()));
        Expression temp = (Expression)this.visitExpression(pr = pr.withMarkers(this.visitMarkers(pr.getMarkers(), newPrimitive.getMarkers())), newPrimitive);
        if (!(temp instanceof J.Primitive)) {
            return temp;
        }
        pr = (J.Primitive)temp;
        return pr.withType(this.visitType(pr.getType(), newPrimitive.getType()));
    }

    @Override
    public J visitReturn(J.Return return_, @Nullable Object ctx) {
        if (return_ == ctx || !(ctx instanceof J.Return)) {
            return return_;
        }
        J.Return newReturn = (J.Return)ctx;
        J.Return r = return_;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.RETURN_PREFIX, newReturn.getPrefix()));
        Statement temp = (Statement)this.visitStatement(r = r.withMarkers(this.visitMarkers(r.getMarkers(), newReturn.getMarkers())), newReturn);
        if (!(temp instanceof J.Return)) {
            return temp;
        }
        r = (J.Return)temp;
        return r.withExpression((Expression)this.visitAndCast(r.getExpression(), newReturn.getExpression()));
    }

    @Override
    public J visitSwitch(J.Switch switch_, @Nullable Object ctx) {
        if (switch_ == ctx || !(ctx instanceof J.Switch)) {
            return switch_;
        }
        J.Switch newSwitch = (J.Switch)ctx;
        J.Switch s = switch_;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SWITCH_PREFIX, newSwitch.getPrefix()));
        Statement temp = (Statement)this.visitStatement(s = s.withMarkers(this.visitMarkers(s.getMarkers(), newSwitch.getMarkers())), newSwitch);
        if (!(temp instanceof J.Switch)) {
            return temp;
        }
        s = (J.Switch)temp;
        s = s.withSelector((J.ControlParentheses)this.visitAndCast(s.getSelector(), newSwitch.getSelector()));
        return s.withCases((J.Block)this.visitAndCast(s.getCases(), newSwitch.getCases()));
    }

    @Override
    public J visitSwitchExpression(J.SwitchExpression switch_, @Nullable Object ctx) {
        if (switch_ == ctx || !(ctx instanceof J.SwitchExpression)) {
            return switch_;
        }
        J.SwitchExpression newSwitch = (J.SwitchExpression)ctx;
        J.SwitchExpression s = switch_;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SWITCH_EXPRESSION_PREFIX, newSwitch.getPrefix()));
        Expression temp = (Expression)this.visitExpression(s = s.withMarkers(this.visitMarkers(s.getMarkers(), newSwitch.getMarkers())), newSwitch);
        if (!(temp instanceof J.SwitchExpression)) {
            return temp;
        }
        s = (J.SwitchExpression)temp;
        s = s.withSelector((J.ControlParentheses)this.visitAndCast(s.getSelector(), newSwitch.getSelector()));
        return s.withCases((J.Block)this.visitAndCast(s.getCases(), newSwitch.getCases()));
    }

    @Override
    public J visitSynchronized(J.Synchronized synch, @Nullable Object ctx) {
        if (synch == ctx || !(ctx instanceof J.Synchronized)) {
            return synch;
        }
        J.Synchronized newSynch = (J.Synchronized)ctx;
        J.Synchronized s = synch;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SYNCHRONIZED_PREFIX, newSynch.getPrefix()));
        Statement temp = (Statement)this.visitStatement(s = s.withMarkers(this.visitMarkers(s.getMarkers(), newSynch.getMarkers())), newSynch);
        if (!(temp instanceof J.Synchronized)) {
            return temp;
        }
        s = (J.Synchronized)temp;
        s = s.withLock((J.ControlParentheses)this.visitAndCast(s.getLock(), newSynch.getLock()));
        return s.withBody((J.Block)this.visitAndCast(s.getBody(), newSynch.getBody()));
    }

    @Override
    public J visitTernary(J.Ternary ternary, @Nullable Object ctx) {
        if (ternary == ctx || !(ctx instanceof J.Ternary)) {
            return ternary;
        }
        J.Ternary newTernary = (J.Ternary)ctx;
        J.Ternary t = ternary;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TERNARY_PREFIX, newTernary.getPrefix()));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTernary.getMarkers())), newTernary);
        if (!(temp instanceof J.Ternary)) {
            return temp;
        }
        t = (J.Ternary)temp;
        Statement tempStat = (Statement)this.visitStatement(t, newTernary);
        if (!(tempStat instanceof J.Ternary)) {
            return tempStat;
        }
        t = (J.Ternary)tempStat;
        t = t.withCondition((Expression)this.visitAndCast(t.getCondition(), newTernary.getCondition()));
        t = t.getPadding().withTruePart(this.visitLeftPadded((JLeftPadded<T>)t.getPadding().getTruePart(), JLeftPadded.Location.TERNARY_TRUE, newTernary.getPadding().getTruePart()));
        t = t.getPadding().withFalsePart(this.visitLeftPadded((JLeftPadded<T>)t.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, newTernary.getPadding().getFalsePart()));
        return t.withType(this.visitType(t.getType(), newTernary.getType()));
    }

    @Override
    public J visitThrow(J.Throw thrown, @Nullable Object ctx) {
        if (thrown == ctx || !(ctx instanceof J.Throw)) {
            return thrown;
        }
        J.Throw newThrown = (J.Throw)ctx;
        J.Throw t = thrown;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.THROW_PREFIX, newThrown.getPrefix()));
        Statement temp = (Statement)this.visitStatement(t = t.withMarkers(this.visitMarkers(t.getMarkers(), newThrown.getMarkers())), newThrown);
        if (!(temp instanceof J.Throw)) {
            return temp;
        }
        t = (J.Throw)temp;
        return t.withException((Expression)this.visitAndCast(t.getException(), newThrown.getException()));
    }

    @Override
    public J visitTry(J.Try tryable, @Nullable Object ctx) {
        if (tryable == ctx || !(ctx instanceof J.Try)) {
            return tryable;
        }
        J.Try newTryable = (J.Try)ctx;
        J.Try t = tryable;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TRY_PREFIX, newTryable.getPrefix()));
        Statement temp = (Statement)this.visitStatement(t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTryable.getMarkers())), newTryable);
        if (!(temp instanceof J.Try)) {
            return temp;
        }
        t = (J.Try)temp;
        if (t.getPadding().getResources() != null) {
            t = t.getPadding().withResources(this.visitContainer((JContainer<J2>)t.getPadding().getResources(), JContainer.Location.TRY_RESOURCES, newTryable.getPadding().getResources()));
        }
        t = t.withBody((J.Block)this.visitAndCast(t.getBody(), newTryable.getBody()));
        if ((t = t.withCatches(ListUtils.map(t.getCatches(), (index, c) -> (J.Try.Catch)this.visitAndCast((Tree)c, newTryable.getCatches().get((int)index))))).getPadding().getFinally() != null) {
            t = t.getPadding().withFinally(this.visitLeftPadded((JLeftPadded<T>)t.getPadding().getFinally(), JLeftPadded.Location.TRY_FINALLY, newTryable.getPadding().getFinally()));
        }
        return t;
    }

    @Override
    public J visitTryResource(J.Try.Resource tryResource, @Nullable Object ctx) {
        if (tryResource == ctx || !(ctx instanceof J.Try.Resource)) {
            return tryResource;
        }
        J.Try.Resource newTryResource = (J.Try.Resource)ctx;
        J.Try.Resource r = tryResource;
        r = tryResource.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.TRY_RESOURCE, newTryResource.getPrefix()));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), newTryResource.getMarkers()));
        return r.withVariableDeclarations((TypedTree)this.visitAndCast(r.getVariableDeclarations(), newTryResource.getVariableDeclarations()));
    }

    @Override
    public J visitTypeCast(J.TypeCast typeCast, @Nullable Object ctx) {
        if (typeCast == ctx || !(ctx instanceof J.TypeCast)) {
            return typeCast;
        }
        J.TypeCast newTypeCast = (J.TypeCast)ctx;
        J.TypeCast t = typeCast;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TYPE_CAST_PREFIX, newTypeCast.getPrefix()));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTypeCast.getMarkers())), newTypeCast);
        if (!(temp instanceof J.TypeCast)) {
            return temp;
        }
        t = (J.TypeCast)temp;
        t = t.withClazz((J.ControlParentheses)this.visitAndCast(t.getClazz(), newTypeCast.getClazz()));
        t = t.withClazz(t.getClazz().withTree(this.visitTypeName((N)t.getClazz().getTree(), (Object)newTypeCast.getClazz().getTree())));
        return t.withExpression((Expression)this.visitAndCast(t.getExpression(), newTypeCast.getExpression()));
    }

    @Override
    public J visitTypeParameter(J.TypeParameter typeParam, @Nullable Object ctx) {
        if (typeParam == ctx || !(ctx instanceof J.TypeParameter)) {
            return typeParam;
        }
        J.TypeParameter newTypeParam = (J.TypeParameter)ctx;
        J.TypeParameter t = typeParam;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TYPE_PARAMETERS_PREFIX, newTypeParam.getPrefix()));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTypeParam.getMarkers()));
        if ((t = t.withAnnotations(ListUtils.map(t.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newTypeParam.getAnnotations().get((int)index))))).getModifiers() != null && !t.getModifiers().isEmpty()) {
            t = t.withModifiers(ListUtils.map(t.getModifiers(), (index, m) -> (J.Modifier)this.visitAndCast((Tree)m, newTypeParam.getModifiers().get((int)index))));
        }
        if ((t = t.withName((Expression)this.visitAndCast(t.getName(), newTypeParam.getName()))).getName() instanceof NameTree) {
            t = t.withName((Expression)((Object)this.visitTypeName((N)((NameTree)((Object)t.getName())), (Object)((NameTree)((Object)newTypeParam.getName())))));
        }
        if (t.getPadding().getBounds() != null) {
            t = t.getPadding().withBounds(this.visitContainer((JContainer<J2>)t.getPadding().getBounds(), JContainer.Location.TYPE_BOUNDS, newTypeParam.getPadding().getBounds()));
        }
        return t.getPadding().withBounds(this.visitTypeNames(t.getPadding().getBounds(), newTypeParam.getPadding().getBounds()));
    }

    @Override
    public J visitTypeParameters(J.TypeParameters typeParameters, @Nullable Object ctx) {
        if (typeParameters == ctx || !(ctx instanceof J.TypeParameters)) {
            return typeParameters;
        }
        J.TypeParameters newTypeParameters = (J.TypeParameters)ctx;
        J.TypeParameters t = typeParameters;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TYPE_PARAMETERS_PREFIX, newTypeParameters.getPrefix()));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), newTypeParameters.getMarkers()));
        t = t.withAnnotations(ListUtils.map(t.getAnnotations(), (index, a) -> (J.Annotation)this.visitAndCast((Tree)a, newTypeParameters.getAnnotations().get((int)index))));
        return t.getPadding().withTypeParameters(ListUtils.map(t.getPadding().getTypeParameters(), (index, tp) -> this.visitRightPadded((JRightPadded<T>)((JRightPadded)tp), JRightPadded.Location.TYPE_PARAMETER, newTypeParameters.getPadding().getTypeParameters().get((int)index))));
    }

    @Override
    public J visitUnary(J.Unary unary, @Nullable Object ctx) {
        if (unary == ctx || !(ctx instanceof J.Unary)) {
            return unary;
        }
        J.Unary newUnary = (J.Unary)ctx;
        J.Unary u = unary;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.UNARY_PREFIX, newUnary.getPrefix()));
        Statement temp = (Statement)this.visitStatement(u = u.withMarkers(this.visitMarkers(u.getMarkers(), newUnary.getMarkers())), newUnary);
        if (!(temp instanceof J.Unary)) {
            return temp;
        }
        u = (J.Unary)temp;
        Expression temp2 = (Expression)this.visitExpression(u, newUnary);
        if (!(temp2 instanceof J.Unary)) {
            return temp2;
        }
        u = (J.Unary)temp2;
        u = u.getPadding().withOperator(this.visitLeftPadded((JLeftPadded<T>)u.getPadding().getOperator(), JLeftPadded.Location.UNARY_OPERATOR, newUnary.getPadding().getOperator()));
        u = u.withExpression((Expression)this.visitAndCast(u.getExpression(), newUnary.getExpression()));
        return u.withType(this.visitType(u.getType(), newUnary.getType()));
    }

    @Override
    public J visitUnknown(J.Unknown unknown, @Nullable Object ctx) {
        if (unknown == ctx || !(ctx instanceof J.Unknown)) {
            return unknown;
        }
        J.Unknown newUnknown = (J.Unknown)ctx;
        J.Unknown u = unknown;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.UNKNOWN_PREFIX, newUnknown.getPrefix()));
        u = u.withMarkers(this.visitMarkers(u.getMarkers(), newUnknown.getMarkers()));
        return u.withSource((J.Unknown.Source)this.visitAndCast(u.getSource(), newUnknown.getSource()));
    }

    @Override
    public J visitUnknownSource(J.Unknown.Source source, @Nullable Object ctx) {
        if (source == ctx || !(ctx instanceof J.Unknown.Source)) {
            return source;
        }
        J.Unknown.Source newSource = (J.Unknown.Source)ctx;
        J.Unknown.Source s = source;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.UNKNOWN_SOURCE_PREFIX, newSource.getPrefix()));
        return s.withMarkers(this.visitMarkers(s.getMarkers(), newSource.getMarkers()));
    }

    @Override
    public J visitVariable(J.VariableDeclarations.NamedVariable variable, @Nullable Object ctx) {
        if (variable == ctx || !(ctx instanceof J.VariableDeclarations.NamedVariable)) {
            return variable;
        }
        J.VariableDeclarations.NamedVariable newVariable = (J.VariableDeclarations.NamedVariable)ctx;
        J.VariableDeclarations.NamedVariable v = variable;
        v = v.withPrefix(this.visitSpace(v.getPrefix(), Space.Location.VARIABLE_PREFIX, newVariable.getPrefix()));
        v = v.withMarkers(this.visitMarkers(v.getMarkers(), newVariable.getMarkers()));
        v = v.withDeclarator((VariableDeclarator)this.visitAndCast(v.getDeclarator(), newVariable.getDeclarator()));
        if ((v = v.withDimensionsAfterName(ListUtils.map(v.getDimensionsAfterName(), (index, dim) -> dim.withBefore(this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, newVariable.getDimensionsAfterName().get((int)index).getBefore())).withElement(this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, newVariable.getDimensionsAfterName().get((int)index).getElement()))))).getPadding().getInitializer() != null) {
            v = v.getPadding().withInitializer(this.visitLeftPadded((JLeftPadded<T>)v.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, newVariable.getPadding().getInitializer()));
        }
        return v.withVariableType((JavaType.Variable)this.visitType(v.getVariableType(), newVariable.getVariableType()));
    }

    @Override
    public J visitWhileLoop(J.WhileLoop whileLoop, @Nullable Object ctx) {
        if (whileLoop == ctx || !(ctx instanceof J.WhileLoop)) {
            return whileLoop;
        }
        J.WhileLoop newWhileLoop = (J.WhileLoop)ctx;
        J.WhileLoop w = whileLoop;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), Space.Location.WHILE_PREFIX, newWhileLoop.getPrefix()));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), newWhileLoop.getMarkers())), newWhileLoop);
        if (!(temp instanceof J.WhileLoop)) {
            return temp;
        }
        w = (J.WhileLoop)temp;
        w = w.withCondition((J.ControlParentheses)this.visitAndCast(w.getCondition(), newWhileLoop.getCondition()));
        return w.getPadding().withBody(this.visitRightPadded((JRightPadded<T>)w.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, newWhileLoop.getPadding().getBody()));
    }

    @Override
    public J visitWildcard(J.Wildcard wildcard, @Nullable Object ctx) {
        if (wildcard == ctx || !(ctx instanceof J.Wildcard)) {
            return wildcard;
        }
        J.Wildcard newWildcard = (J.Wildcard)ctx;
        J.Wildcard w = wildcard;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), Space.Location.WILDCARD_PREFIX, newWildcard.getPrefix()));
        Expression temp = (Expression)this.visitExpression(w = w.withMarkers(this.visitMarkers(w.getMarkers(), newWildcard.getMarkers())), newWildcard);
        if (!(temp instanceof J.Wildcard)) {
            return temp;
        }
        w = (J.Wildcard)temp;
        w = w.getPadding().withBound(this.visitLeftPadded((JLeftPadded<T>)w.getPadding().getBound(), JLeftPadded.Location.WILDCARD_BOUND, newWildcard.getPadding().getBound()));
        if ((w = w.withBoundedType((NameTree)this.visitAndCast(w.getBoundedType(), newWildcard.getBoundedType()))).getBoundedType() != null) {
            w = w.withBoundedType(this.visitTypeName((N)w.getBoundedType(), (Object)newWildcard.getBoundedType()));
        }
        return w;
    }

    @Override
    public J visitYield(J.Yield yield, @Nullable Object ctx) {
        if (yield == ctx || !(ctx instanceof J.Yield)) {
            return yield;
        }
        J.Yield newYield = (J.Yield)ctx;
        J.Yield y = yield;
        y = y.withPrefix(this.visitSpace(y.getPrefix(), Space.Location.YIELD_PREFIX, newYield.getPrefix()));
        Statement temp = (Statement)this.visitStatement(y = y.withMarkers(this.visitMarkers(y.getMarkers(), newYield.getMarkers())), newYield);
        if (!(temp instanceof J.Yield)) {
            return temp;
        }
        y = (J.Yield)temp;
        return y.withValue((Expression)this.visitAndCast(y.getValue(), newYield.getValue()));
    }

    @Override
    public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, @Nullable Object ctx) {
        JRightPadded newRight = (JRightPadded)ctx;
        if (right == newRight) {
            return right;
        }
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((J)right.getElement(), newRight.getElement());
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), newRight.getAfter());
        Markers markers = this.visitMarkers(right.getMarkers(), newRight.getMarkers());
        return after == right.getAfter() && t == right.getElement() && markers == right.getMarkers() ? right : new JRightPadded<T>(t, after, markers);
    }

    @Override
    public <T> @Nullable JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, JLeftPadded.Location loc, @Nullable Object ctx) {
        JLeftPadded newLeft = (JLeftPadded)ctx;
        if (left == newLeft) {
            return left;
        }
        if (left == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), left));
        Space before = this.visitSpace(left.getBefore(), loc.getBeforeLocation(), newLeft.getBefore());
        Object t = left.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((J)left.getElement(), newLeft.getElement());
        }
        this.setCursor(this.getCursor().getParent());
        if (left.getElement() == t && before == left.getBefore()) {
            return left;
        }
        return t == null ? null : new JLeftPadded<T>(before, t, left.getMarkers());
    }

    @Override
    public <J2 extends J> @Nullable JContainer<J2> visitContainer(@Nullable JContainer<J2> container, JContainer.Location loc, @Nullable Object ctx) {
        JContainer newContainer = (JContainer)ctx;
        if (container == newContainer) {
            return container;
        }
        if (container == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), newContainer.getBefore());
        List js = ListUtils.map(container.getPadding().getElements(), (index, t) -> this.visitRightPadded((JRightPadded<T>)((JRightPadded)t), loc.getElementLocation(), newContainer == null ? null : newContainer.getPadding().getElements().get((int)index)));
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build(before, js, container.getMarkers());
    }

    @Override
    public J visitErroneous(J.Erroneous erroneous, @Nullable Object ctx) {
        if (erroneous == ctx || !(ctx instanceof J.Erroneous)) {
            return erroneous;
        }
        J.Erroneous newErroneous = (J.Erroneous)ctx;
        J.Erroneous u = erroneous;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.ERRONEOUS, newErroneous.getPrefix()));
        return u.withMarkers(this.visitMarkers(u.getMarkers(), newErroneous.getMarkers()));
    }
}

