/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public final class ChangeText
extends Recipe {
    @Option(displayName="Text after change", description="The text file will have only this text after the change. The snippet provided here can be multiline.", example="Some text.")
    private final String toText;

    @Override
    public Set<String> getTags() {
        return Collections.singleton("plain text");
    }

    @Override
    public String getDisplayName() {
        return "Change text";
    }

    @Override
    public String getInstanceNameSuffix() {
        return "to `" + this.toText + "`";
    }

    @Override
    public String getDescription() {
        return "Completely replaces the contents of the text file with other text. Use together with a `FindSourceFiles` precondition to limit which files are changed.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PlainTextVisitor<ExecutionContext>(){

            @Override
            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                return text.withSnippets(Collections.emptyList()).withText(ChangeText.this.toText);
            }
        };
    }

    @Generated
    public ChangeText(String toText) {
        this.toText = toText;
    }

    @Generated
    public String getToText() {
        return this.toText;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeText(toText=" + this.getToText() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeText)) {
            return false;
        }
        ChangeText other = (ChangeText)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$toText = this.getToText();
        String other$toText = other.getToText();
        return !(this$toText == null ? other$toText != null : !this$toText.equals(other$toText));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeText;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $toText = this.getToText();
        result = result * 59 + ($toText == null ? 43 : $toText.hashCode());
        return result;
    }
}

