/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.time.Duration;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Statement;

public class OptionalNotPresentToIsEmpty
extends Recipe {
    public String getDisplayName() {
        return "Prefer `Optional.isEmpty()`";
    }

    public String getDescription() {
        return "Prefer `Optional.isEmpty()` instead of using `!Optional.isPresent()` in Java 11 or higher.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher optionalIsPresentMatcher = new MethodMatcher("java.util.Optional isPresent()");
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(11), new UsesMethod(optionalIsPresentMatcher)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitStatement(Statement s, ExecutionContext ctx) {
                J.Unary unary;
                if (s instanceof J.Unary && (unary = (J.Unary)s).getOperator() == J.Unary.Type.Not && optionalIsPresentMatcher.matches(unary.getExpression())) {
                    return JavaTemplate.apply((String)"#{any(java.util.Optional)}.isEmpty()", (Cursor)this.getCursor(), (JavaCoordinates)unary.getCoordinates().replace(), (Object[])new Object[]{((J.MethodInvocation)unary.getExpression()).getSelect()});
                }
                return super.visitStatement(s, (Object)ctx);
            }
        });
    }
}

