/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import java.util.Collections;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ApplicationPathWildcardNoLongerAccepted
extends Recipe {
    public String getDisplayName() {
        return "Remove trailing slash from `jakarta.ws.rs.ApplicationPath` values";
    }

    public String getDescription() {
        return "Remove trailing `/*` from `jakarta.ws.rs.ApplicationPath` values.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ApplicationPathTrailingSlashVisitor();
    }

    private static class ApplicationPathTrailingSlashVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final AnnotationMatcher APPLICATION_PATH = new AnnotationMatcher("@jakarta.ws.rs.ApplicationPath");

        public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            J.Literal literal;
            String value;
            J.Annotation a = super.visitAnnotation(annotation, (Object)ctx);
            if (!APPLICATION_PATH.matches(a) || a.getArguments() == null || a.getArguments().isEmpty()) {
                return a;
            }
            Expression it = (Expression)a.getArguments().get(0);
            if (it instanceof J.Assignment) {
                J.Literal literal2;
                String value2;
                J.Assignment assig = (J.Assignment)it;
                if (assig.getAssignment() instanceof J.Literal && (value2 = (literal2 = (J.Literal)assig.getAssignment()).getValue().toString()).endsWith("/*")) {
                    String newValue = "\"" + value2.substring(0, value2.length() - 2) + "\"";
                    return a.withArguments(Collections.singletonList(assig.withAssignment((Expression)literal2.withValue((Object)newValue).withValueSource(newValue))));
                }
            } else if (it instanceof J.Literal && (value = (literal = (J.Literal)it).getValue().toString()).endsWith("/*")) {
                String newValue = "\"" + value.substring(0, value.length() - 2) + "\"";
                return a.withArguments(Collections.singletonList(((J.Literal)it).withValue((Object)newValue).withValueSource(newValue)));
            }
            return a;
        }

        @Generated
        public ApplicationPathTrailingSlashVisitor() {
        }
    }
}

