/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;

public class ProcessUtils {
    public static void addIndexToProperties(List<Object> models, int initialIndex) {
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            int i = initialIndex;
            for (CodegenProperty var : cm.vars) {
                var.vendorExtensions.put("x-index", i);
                ++i;
            }
            int j = initialIndex;
            for (CodegenProperty var : cm.allVars) {
                var.vendorExtensions.put("x-index", j);
                ++j;
            }
        }
    }

    public static void addIndexToProperties(List<Object> models) {
        ProcessUtils.addIndexToProperties(models, 0);
    }

    public static boolean hasOAuthMethods(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.authMethods == null || operation.authMethods.isEmpty()) continue;
                for (CodegenSecurity cs : operation.authMethods) {
                    if (!Boolean.TRUE.equals(cs.isOAuth)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasBearerMethods(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.authMethods == null || operation.authMethods.isEmpty()) continue;
                for (CodegenSecurity cs : operation.authMethods) {
                    if (!Boolean.TRUE.equals(cs.isBasicBearer)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasHttpBasicMethods(List<CodegenSecurity> authMethods) {
        if (authMethods != null && !authMethods.isEmpty()) {
            for (CodegenSecurity cs : authMethods) {
                if (!Boolean.TRUE.equals(cs.isBasicBasic)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasApiKeyMethods(List<CodegenSecurity> authMethods) {
        if (authMethods != null && !authMethods.isEmpty()) {
            for (CodegenSecurity cs : authMethods) {
                if (!Boolean.TRUE.equals(cs.isApiKey)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasHttpSignatureMethods(List<CodegenSecurity> authMethods) {
        if (authMethods != null && !authMethods.isEmpty()) {
            for (CodegenSecurity cs : authMethods) {
                if (!Boolean.TRUE.equals(cs.isHttpSignature)) continue;
                return true;
            }
        }
        return false;
    }
}

