/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.EnumSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractGoCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoClientCodegen
extends AbstractGoCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoClientCodegen.class);
    protected String packageVersion = "1.0.0";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected boolean isGoSubmodule = false;
    public static final String WITH_GO_CODEGEN_COMMENT = "withGoCodegenComment";
    public static final String WITH_XML = "withXml";
    public static final String STRUCT_PREFIX = "structPrefix";
    public static final String WITH_AWSV4_SIGNATURE = "withAWSV4Signature";

    public GoClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterizedServer}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.outputFolder = "generated-code/go";
        this.modelTemplateFiles.put("model.mustache", ".go");
        this.apiTemplateFiles.put("api.mustache", ".go");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "go";
        this.embeddedTemplateDir = "go";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.cliOptions.add(CliOption.newBoolean("isGoSubmodule", "whether the generated Go module is a submodule"));
        this.cliOptions.add(CliOption.newBoolean(WITH_GO_CODEGEN_COMMENT, "whether to include Go codegen comment to disable Go Lint and collapse by default in GitHub PRs and diffs"));
        this.cliOptions.add(CliOption.newBoolean(WITH_XML, "whether to include support for application/xml content type and include XML annotations in the model (works with libraries that provide support for JSON and XML)"));
        this.cliOptions.add(CliOption.newBoolean("enumClassPrefix", "Prefix enum with class name"));
        this.cliOptions.add(CliOption.newBoolean(STRUCT_PREFIX, "whether to prefix struct with the class name. e.g. DeletePetOpts => PetApiDeletePetOpts"));
        this.cliOptions.add(CliOption.newBoolean(WITH_AWSV4_SIGNATURE, "whether to include AWS v4 signature support"));
        this.cliOptions.add(CliOption.newBoolean("prependFormOrBodyParameters", "Add form or body parameters to the beginning of the parameter list.").defaultValue(Boolean.FALSE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "api", "openapi.yaml"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", "", "configuration.go"));
        this.supportingFiles.add(new SupportingFile("client.mustache", "", "client.go"));
        this.supportingFiles.add(new SupportingFile("response.mustache", "", "response.go"));
        this.supportingFiles.add(new SupportingFile("go.mod.mustache", "", "go.mod"));
        this.supportingFiles.add(new SupportingFile("go.sum", "", "go.sum"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", "", ".travis.yml"));
        if (this.additionalProperties.containsKey(WITH_GO_CODEGEN_COMMENT)) {
            this.setWithGoCodegenComment(Boolean.parseBoolean(this.additionalProperties.get(WITH_GO_CODEGEN_COMMENT).toString()));
            if (this.withGoCodegenComment) {
                this.additionalProperties.put(WITH_GO_CODEGEN_COMMENT, "true");
            }
        }
        if (this.additionalProperties.containsKey(WITH_AWSV4_SIGNATURE)) {
            this.setWithAWSV4Signature(Boolean.parseBoolean(this.additionalProperties.get(WITH_AWSV4_SIGNATURE).toString()));
            if (this.withAWSV4Signature) {
                this.additionalProperties.put(WITH_AWSV4_SIGNATURE, "true");
            }
        }
        if (this.additionalProperties.containsKey(WITH_XML)) {
            this.setWithXml(Boolean.parseBoolean(this.additionalProperties.get(WITH_XML).toString()));
            if (this.withXml) {
                this.additionalProperties.put(WITH_XML, "true");
            }
        }
        if (this.additionalProperties.containsKey("enumClassPrefix")) {
            this.setEnumClassPrefix(Boolean.parseBoolean(this.additionalProperties.get("enumClassPrefix").toString()));
            if (this.enumClassPrefix) {
                this.additionalProperties.put("enumClassPrefix", "true");
            }
        }
        if (this.additionalProperties.containsKey("isGoSubmodule")) {
            this.setIsGoSubmodule(Boolean.parseBoolean(this.additionalProperties.get("isGoSubmodule").toString()));
            if (this.isGoSubmodule) {
                this.additionalProperties.put("isGoSubmodule", "true");
            }
        }
        if (this.additionalProperties.containsKey(STRUCT_PREFIX)) {
            this.setStructPrefix(Boolean.parseBoolean(this.additionalProperties.get(STRUCT_PREFIX).toString()));
            if (this.structPrefix) {
                this.additionalProperties.put(STRUCT_PREFIX, "true");
            }
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "go";
    }

    @Override
    public String getHelp() {
        return "Generates a Go client library (beta).";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator;
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setIsGoSubmodule(boolean isGoSubmodule) {
        this.isGoSubmodule = isGoSubmodule;
    }
}

