/*
 * #%L
 * Wikitty :: ui-zk
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.ui;

/**
 *
 * @author sherkhan
 */
public class Data {

    protected String _path = "";
    protected String _name = "";
    protected String _db = "";
    protected String _driver = "";
    protected String _solr = "";
    protected String _URL = "";
    protected String _login = "";
    protected String _password = "";

    public Data(String name, String db, String driver, String solr, String url, String login, String password) {
        setName(name);
        setDb(db);
        setDriver(driver);
        setSolr(solr);
        setURL(url);
        setLogin(login);
        setPassword(password);
    }

    public boolean hasLoginPassword() {
        if (_password.isEmpty() || _login.isEmpty()) {
            return false;
        }
        return true;
    }

    /*
     * Setters
     */
    public void setPath(String path) {
        if (path == null) {
            path = "";
        }
        _path = path;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        _name = name;
    }

    public void setDb(String db) {
        if (db == null) {
            db = "";
        }
        _db = db;
    }

    public void setSolr(String solr) {
        if (solr == null) {
            solr = "";
        }
        _solr = solr;
    }

    public void setURL(String URL) {
        if (URL == null) {
            URL = "";
        }
        _URL = URL;
    }

    public void setLogin(String login) {
        if (login == null) {
            login = "";
        }
        _login = login;
    }

    public void setPassword(String password) {
        if (password == null) {
            password = "";
        }
        _password = password;
    }

    public void setDriver(String driver) {
        if (driver == null) {
            driver = "";
        }
        _driver = driver;
    }

    public void setAll(String name, String db, String driver, String solr, String url, String login, String password) {
        setName(name);
        setDb(db);
        setDriver(driver);
        setSolr(solr);
        setURL(url);
        setLogin(login);
        setPassword(password);
    }

    /*
     * Getters
     */
    public String getPath() {
        return _path;
    }

    public String getName() {
        return _name;
    }

    public String getDb() {
        return _db;
    }

    public String getDriver() {
        return _driver;
    }

    public String getSolr() {
        return _solr;
    }

    public String getUrl() {
        return _URL;
    }

    public String getLogin() {
        return _login;
    }

    public String getPassword() {
        return _password;
    }
}
