/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.FieldType;

public class SolrUtil {
    private static Log log = LogFactory.getLog(SolrUtil.class);

    public static Set<String> getAttachedTreeNode(SolrDocument doc) {
        HashSet<String> result = new HashSet<String>();
        for (String field : doc.getFieldNames()) {
            if (!field.startsWith("#tree.attached.")) continue;
            String id = field.substring("#tree.attached.".length());
            result.add(id);
        }
        return result;
    }

    public static SolrDocument findById(SolrServer solrServer, String id) {
        QueryResponse response;
        id = SolrUtil.quoteForSolr(id);
        SolrQuery query = new SolrQuery("#id:" + id);
        try {
            response = solrServer.query((SolrParams)query);
        }
        catch (SolrServerException eee) {
            throw new WikittyException("Error during find", (Throwable)eee);
        }
        SolrDocumentList results = response.getResults();
        long numFound = results.getNumFound();
        if (numFound == 1L) {
            return (SolrDocument)results.get(0);
        }
        return null;
    }

    public static Map<String, SolrDocument> findAllById(SolrServer solrServer, Collection<String> ids) {
        String solrField = "#id";
        Map<String, SolrDocument> result = SolrUtil.findAllByField(solrServer, solrField, ids);
        return result;
    }

    public static Map<String, SolrDocument> findAllByParents(SolrServer solrServer, Collection<String> ids) {
        String solrField = "#tree.parents";
        Map<String, SolrDocument> result = SolrUtil.findAllByField(solrServer, solrField, ids);
        return result;
    }

    public static Map<String, SolrDocument> findAllByAttachment(SolrServer solrServer, Collection<String> ids) {
        String solrField = SolrUtil.getSolrFieldName("WikittyTreeNode.attachment", FieldType.TYPE.WIKITTY);
        Map<String, SolrDocument> result = SolrUtil.findAllByField(solrServer, solrField, ids);
        return result;
    }

    public static Map<String, SolrDocument> findAllByField(SolrServer solrServer, String solrField, Collection<String> ids) {
        HashMap<String, SolrDocument> result = new HashMap<String, SolrDocument>();
        if (ids != null && ids.size() > 0) {
            try {
                String request = solrField + ":(";
                String or = "";
                for (String id : ids) {
                    id = SolrUtil.quoteForSolr(id);
                    request = request + or + id;
                    or = " OR ";
                }
                request = request + ")";
                SolrQuery query = new SolrQuery(request);
                QueryResponse response = solrServer.query((SolrParams)query);
                SolrDocumentList results = response.getResults();
                for (SolrDocument doc : results) {
                    String id = (String)doc.getFieldValue("#id");
                    result.put(id, doc);
                }
            }
            catch (SolrServerException eee) {
                throw new WikittyException("Error during find", (Throwable)eee);
            }
        }
        return result;
    }

    public static String getSolrFieldName(String fqfieldName, FieldType.TYPE type) {
        switch (type) {
            case BINARY: {
                return fqfieldName + "_bi";
            }
            case BOOLEAN: {
                return fqfieldName + "_b";
            }
            case DATE: {
                return fqfieldName + "_dt";
            }
            case STRING: {
                return fqfieldName + "_s";
            }
            case NUMERIC: {
                return fqfieldName + "_d";
            }
            case WIKITTY: {
                return fqfieldName + "_w";
            }
        }
        return fqfieldName;
    }

    public static void copySolrDocument(SolrDocument source, SolrInputDocument dest, String[] fieldToInclude, String[] fieldToExclude) {
        Collection fieldNames = source.getFieldNames();
        HashSet<String> fieldToCopy = new HashSet<String>();
        if (fieldToInclude == null || fieldToInclude.length == 0) {
            fieldToCopy.addAll(fieldNames);
        } else {
            block0: for (String fieldName : fieldNames) {
                for (String fieldRegexp : fieldToInclude) {
                    if (!fieldName.matches(fieldRegexp)) continue;
                    fieldToCopy.add(fieldName);
                    continue block0;
                }
            }
        }
        if (fieldToExclude != null && fieldToExclude.length > 0) {
            block2: for (String fieldName : fieldNames) {
                for (String fieldRegexp : fieldToExclude) {
                    if (!fieldName.matches(fieldRegexp)) continue;
                    fieldToCopy.remove(fieldName);
                    continue block2;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Copiable field are %s but only field %s are copied", fieldNames, fieldToCopy));
        }
        for (String fieldName : fieldToCopy) {
            dest.removeField(fieldName);
            Collection fieldValues = source.getFieldValues(fieldName);
            for (Object fieldValue : fieldValues) {
                dest.addField(fieldName, fieldValue);
            }
        }
    }

    public static void copySolrDocument(SolrDocument source, SolrInputDocument dest, String ... fieldToInclude) {
        SolrUtil.copySolrDocument(source, dest, fieldToInclude, null);
    }

    public static void copySolrDocumentExcludeSomeField(SolrDocument source, SolrInputDocument dest, String ... fieldToExclude) {
        SolrUtil.copySolrDocument(source, dest, null, fieldToExclude);
    }

    public static String quoteForSolr(String s) {
        String result = s.replaceAll(":", "\\\\:");
        return result;
    }
}

