/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication.ui.action;

import com.opensymphony.xwork2.ActionContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.ScriptEvaluator;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.publication.AbstractDecoredClass;
import org.nuiton.wikitty.publication.CodeDecorator;
import org.nuiton.wikitty.publication.EvalInterface;
import org.nuiton.wikitty.publication.PublicationContext;
import org.nuiton.wikitty.publication.entities.WikittyPubDataHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubTextCompiledHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubTextCompiledImpl;
import org.nuiton.wikitty.publication.entities.WikittyPubTextHelper;
import org.nuiton.wikitty.publication.externalize.CompileHelper;
import org.nuiton.wikitty.publication.externalize.JarUtil;
import org.nuiton.wikitty.publication.externalize.WikittyPublicationClassLoader;
import org.nuiton.wikitty.publication.ui.action.PublicationBaseAction;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;

public class PublicationActionEval
extends PublicationBaseAction
implements ServletResponseAware,
ServletRequestAware,
PublicationContext,
EvalInterface {
    private static final long serialVersionUID = -7649132751822833474L;
    private static Log log = LogFactory.getLog(PublicationActionEval.class);
    protected static String JAVA_TEMP_DIR_NAME = "PublicationJavaEvalDir";
    protected static String JAR_TEMP_DIR_NAME = "PublicationJarRepository";
    protected static String MD5_FILE = "JarMD5";
    protected String contentType;
    protected HttpServletResponse response;
    protected HttpServletRequest request;
    protected InputStream inputStream;
    protected WikittyPublicationClassLoader classloader;
    protected List<File> classPathSup;

    public void setServletResponse(HttpServletResponse arg0) {
        this.response = arg0;
    }

    public void setServletRequest(HttpServletRequest arg0) {
        this.request = arg0;
    }

    public String execute() throws Exception {
        URL[] urls = this.getJarsDependency();
        this.classloader = new WikittyPublicationClassLoader(urls);
        Thread.currentThread().setContextClassLoader((ClassLoader)this.classloader);
        this.doAction((PublicationContext)this, this.getMandatoryArguments());
        return "success";
    }

    protected URL[] getJarsDependency() throws IOException, MalformedURLException {
        if (!FileUtils.getTempDirectory().exists()) {
            FileUtils.getTempDirectory().mkdir();
        }
        Search wikittyPubDataJarCrit = Search.query().eq("WikittyPubData.mimeType", "application/jar");
        String jarRepoPath = FileUtils.getTempDirectory().getAbsolutePath() + File.separator + JAR_TEMP_DIR_NAME;
        if (this.contextApps != null) {
            jarRepoPath = jarRepoPath + File.separator + this.contextApps;
            wikittyPubDataJarCrit.exteq("WikittyLabel").sw("WikittyLabel.labels", this.contextApps);
        }
        File jarRepo = new File(jarRepoPath + File.separator);
        File md5File = new File(jarRepo.getAbsolutePath() + File.separator + MD5_FILE);
        if (!jarRepo.exists()) {
            jarRepo.mkdir();
        }
        md5File.createNewFile();
        String md5ref = FileUtil.readAsString((File)md5File);
        PagedResult jardatas = this.getWikittyProxy().findAllByCriteria(wikittyPubDataJarCrit.criteria());
        String sumMd5 = "";
        for (Wikitty w : jardatas) {
            sumMd5 = sumMd5 + w.getId();
            sumMd5 = sumMd5 + w.getVersion();
        }
        if (!(sumMd5 = StringUtil.encodeMD5((String)sumMd5)).equals(md5ref)) {
            FileUtil.writeString((File)md5File, (String)sumMd5);
            for (Wikitty w : jardatas) {
                String name = WikittyPubDataHelper.getName((Wikitty)w);
                byte[] content = WikittyPubDataHelper.getContent((Wikitty)w);
                File tempJar = new File(jarRepo.getAbsolutePath() + File.separator + name + ".jar");
                FileUtils.writeByteArrayToFile((File)tempJar, (byte[])content);
            }
        }
        File[] jarFiles = jarRepo.listFiles(JarUtil.jarFilter);
        URL[] urls = new URL[1];
        this.classPathSup = new LinkedList();
        this.classPathSup.add(jarRepo);
        urls[0] = jarRepo.toURI().toURL();
        if (jarFiles != null) {
            urls = new URL[jarFiles.length + 1];
            int i = 0;
            urls[i] = jarRepo.toURI().toURL();
            ++i;
            for (File fj : jarFiles) {
                this.classPathSup.add(fj);
                urls[i] = fj.toURI().toURL();
                ++i;
            }
        }
        return urls;
    }

    public Object doAction(PublicationContext context, List<String> subContext) {
        Object result;
        log.info((Object)("path " + subContext));
        CodeDecorator decorator = new CodeDecorator();
        Criteria criteria = this.searchCriteria(subContext);
        if (criteria == null) {
            result = "";
        } else {
            WikittyProxy proxy = context.getWikittyProxy();
            Wikitty w = proxy.findByCriteria(criteria);
            if (w == null || !w.hasExtension("WikittyPubText")) {
                if (w != null && w.hasExtension("WikittyPubData")) {
                    this.contentType = WikittyPubDataHelper.getMimeType((Wikitty)w);
                    this.inputStream = new ByteArrayInputStream(WikittyPubDataHelper.getContent((Wikitty)w));
                    return WikittyPubDataHelper.getContent((Wikitty)w);
                }
                context.setContentType("text/plain");
                result = String.format("no data found for criteria '%s'", criteria);
            } else if (w.hasExtension("WikittyPubTextCompiled") || WikittyPubTextHelper.getMimeType((Wikitty)w).equals("text/java")) {
                result = this.evalJava(context, subContext, decorator, criteria, w);
            } else {
                String content;
                log.debug((Object)"Check if transformed needed");
                if (decorator.isTransformationNeeded(w)) {
                    log.debug((Object)"transformeneed");
                    try {
                        w = decorator.transformPubUIToPubText(w);
                    }
                    catch (IOException e) {
                        log.debug((Object)"Error when processing the wikitty content");
                        e.printStackTrace();
                        result = this.getError(context);
                    }
                }
                if ((content = WikittyPubTextHelper.getContent((Wikitty)w)) == null) {
                    result = this.getError(context);
                } else {
                    String mimetype = WikittyPubTextHelper.getMimeType((Wikitty)w);
                    if (mimetype.equals("text/java")) {
                        result = this.evalJava(context, subContext, decorator, criteria, w);
                    } else {
                        subContext = new ArrayList<String>(subContext.subList(1, subContext.size()));
                        HashMap<String, Object> bindings = new HashMap<String, Object>();
                        bindings.put("wpPage", criteria.getName());
                        bindings.put("wpContext", context);
                        bindings.put("wpSubContext", subContext);
                        bindings.put("wpWikitty", w);
                        bindings.put("wpEval", this);
                        result = ScriptEvaluator.eval((ClassLoader)this.classloader, (String)criteria.getName(), (String)content, (String)mimetype, bindings);
                    }
                }
            }
        }
        this.inputStream = new ByteArrayInputStream(result.toString().getBytes());
        return result;
    }

    protected Object evalJava(PublicationContext context, List<String> subContext, CodeDecorator decorator, Criteria criteria, Wikitty w) {
        Object result;
        byte[] content;
        if (WikittyPubTextHelper.getMimeType((Wikitty)w).equals("text/java")) {
            File javaWikittyFile;
            String name = WikittyPubTextHelper.getName((Wikitty)w);
            if (!FileUtils.getTempDirectory().exists()) {
                FileUtils.getTempDirectory().mkdir();
            }
            if (!(javaWikittyFile = new File(FileUtils.getTempDirectory().getAbsolutePath() + File.separator + JAVA_TEMP_DIR_NAME)).exists()) {
                javaWikittyFile.mkdir();
            }
            String javaContent = decorator.getCode(w);
            String content2 = null;
            try {
                File javaFile = new File(javaWikittyFile.getAbsolutePath() + File.separator + name + ".java");
                File clazzFile = new File(javaWikittyFile.getAbsolutePath() + File.separator + name + ".class");
                if (javaFile.exists()) {
                    content2 = FileUtil.readAsString((File)javaFile);
                }
                if (content2 == null || !StringUtil.encodeMD5((String)javaContent).equals(StringUtil.encodeMD5((String)content2)) || !clazzFile.exists()) {
                    javaFile.createNewFile();
                    FileUtil.writeString((File)javaFile, (String)javaContent);
                    PrintWriter writer = new PrintWriter(System.out);
                    CompileHelper.compile((List)this.classPathSup, (File)javaWikittyFile, (File)javaFile, (File)javaWikittyFile, (PrintWriter)writer);
                }
                File classFile = new File(javaWikittyFile.getAbsolutePath() + File.separator + name + ".class");
                byte[] wikittyByte = FileUtil.fileToByte((File)classFile);
                w.addExtension(WikittyPubTextCompiledImpl.extensionWikittyPubTextCompiled);
                WikittyPubTextCompiledHelper.setByteCode((Wikitty)w, (byte[])wikittyByte);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Error while transforming wikittyPubText to wikittyPubTextCompiled wikitty:" + w), (Throwable)e);
                }
                String string = this.getError(context);
            }
        }
        if ((content = WikittyPubTextCompiledHelper.getByteCode((Wikitty)w)) == null) {
            result = this.getError(context);
        } else {
            String name = WikittyPubTextHelper.getName((Wikitty)w);
            subContext = new ArrayList<String>(subContext.subList(1, subContext.size()));
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.put("wpPage", criteria.getName());
            bindings.put("wpContext", context);
            bindings.put("wpSubContext", subContext);
            bindings.put("wpWikitty", w);
            bindings.put("wpEval", this);
            Class clazz = this.classloader.addClass(name, content);
            try {
                result = ((AbstractDecoredClass)clazz.newInstance()).eval(bindings);
            }
            catch (Exception e) {
                e.printStackTrace();
                result = this.getError(context);
            }
        }
        return result;
    }

    public Object doAction(PublicationContext context, String subContextAsText) {
        Object result;
        if (subContextAsText == null || "".equals(subContextAsText)) {
            result = this.getError(context);
        } else {
            if (subContextAsText.startsWith("/")) {
                subContextAsText = subContextAsText.substring(1);
            }
            String[] subContextArray = StringUtil.split((String)subContextAsText, (String)"/");
            List<String> subContext = Arrays.asList(subContextArray);
            result = this.doAction(context, subContext);
        }
        return result;
    }

    public Object doAction(PublicationContext context) {
        Object result = context.getMandatoryArguments().size() <= 0 ? this.getError(context) : this.doAction(context, context.getMandatoryArguments());
        return result;
    }

    public String getMimeType() {
        return this.contentType;
    }

    public void setMimeType(String mimeType) {
        this.contentType = mimeType;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String makeUrl(String url) {
        String finalUrl = url;
        if (!finalUrl.startsWith("/")) {
            finalUrl = "/" + finalUrl;
        }
        finalUrl = this.getRequest().getContextPath() + "/" + this.getArgument(CONTEXT_DATA_KEY, "") + finalUrl;
        finalUrl = this.getResponse().encodeURL(finalUrl) + ".action";
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("transforme url from '%s' to '%s'", url, finalUrl));
        }
        return finalUrl;
    }

    public WikittyService getWikittyService() {
        return this.getWikittyPublicationProxy().getWikittyService();
    }

    public List<String> getMandatoryArguments() {
        ArrayList<String> argsString = new ArrayList<String>();
        String args = ActionContext.getContext().getParameters().get(ARGS_KEY).toString();
        String[] argsTab = StringUtil.split((String)args, (String)SEPARATOR);
        Collections.addAll(argsString, argsTab);
        return argsString;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public WikittyProxy getWikittyProxy() {
        return this.getWikittyPublicationProxy();
    }

    public Map<String, String> getArguments() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String argElm : ActionContext.getContext().getParameters().keySet()) {
            result.put(argElm, this.getArgument(argElm, ""));
        }
        return result;
    }

    public String getArgument(String name) {
        return this.getArgument(name, "");
    }
}

